<?php
global $wpdb;
$countries = $wpdb->get_results( "SELECT iso2_cnt, name_cnt FROM ec_country ORDER BY name_cnt ASC" );
?>
<div class="ec_admin_list_line_item">
    
	<?php wp_easycart_admin( )->preloader->print_preloader( "ec_admin_shipping_fedex_display_loader" ); ?>
    
    <div class="ec_admin_settings_label"><div class="dashicons-before dashicons-screenoptions"></div><span>FedEx Setup</span><a href="<?php echo wp_easycart_admin( )->helpsystem->print_docs_url('settings', 'shipping-settings', 'fedex');?>" target="_blank" class="ec_help_icon_link"><div class="dashicons-before ec_help_icon dashicons-info"></div></a>
    <?php echo wp_easycart_admin( )->helpsystem->print_vids_url('settings', 'shipping-settings', 'fedex');?></div>
    
    <div class="ec_admin_settings_input ec_admin_settings_live_payment_section">
    
    	<div>Access Key <input type="text" name="fedex_key" id="fedex_key" value="<?php echo wp_easycart_admin( )->settings->fedex_key; ?>" /></div>
        <div>Account Number <input type="text" name="fedex_account_number" id="fedex_account_number" value="<?php echo wp_easycart_admin( )->settings->fedex_account_number; ?>" /></div>
        <div>Meter Number <input type="text" name="fedex_meter_number" id="fedex_meter_number" value="<?php echo wp_easycart_admin( )->settings->fedex_meter_number; ?>" /></div>
        <div>Ship From Postal Code <input type="text" name="fedex_ship_from_zip" id="fedex_ship_from_zip" value="<?php echo wp_easycart_admin( )->settings->fedex_ship_from_zip; ?>" /></div>
        <div>Password <input type="password" name="fedex_password" id="fedex_password" value="<?php echo wp_easycart_admin( )->settings->fedex_password; ?>" /></div>
        <div>Country Code <select name="fedex_country_code" id="fedex_country_code">
        	<option value="US"<?php if( wp_easycart_admin( )->settings->fedex_country_code == 'US' ){ ?> selected="selected"<?php }?>>United States</option>
            <?php foreach( $countries as $country ){ ?>
			<option value="<?php echo $country->iso2_cnt; ?>"<?php if( $country->iso2_cnt == wp_easycart_admin( )->settings->fedex_country_code ){ ?> selected="selected"<?php }?>><?php echo $country->name_cnt; ?></option>
			<?php } ?>
        </select></div>
        <div>Weight Unit <select name="fedex_weight_units" id="fedex_weight_units">
        	<option value="LB"<?php if( wp_easycart_admin( )->settings->fedex_weight_units == 'LB' ){ ?> selected="selected"<?php }?>>LB</option>
            <option value="KG"<?php if( wp_easycart_admin( )->settings->fedex_weight_units == 'KG' ){ ?> selected="selected"<?php }?>>KG</option>
        </select></div>
        <div>Conversion Rate <input type="text" name="fedex_conversion_rate" id="fedex_conversion_rate" value="<?php echo wp_easycart_admin( )->settings->fedex_conversion_rate; ?>" /></div>
        <div><input type="checkbox" name="fedex_test_account" id="fedex_test_account" value="1"<?php if( wp_easycart_admin( )->settings->fedex_test_account ){ ?> checked="checked"<?php }?>/>Test Mode</div>
        
    </div>
    
    <div class="ec_admin_settings_input">
        <input type="submit" class="ec_admin_settings_simple_button" onclick="return ec_admin_save_fedex_shipping_options( );" value="Save Options" />
    	<?php $fedex_status = wp_easycart_admin_live_shipping_rates_pro( )->get_fedex_status( ); ?>
        <div class="ec_admin_live_shipping_status_<?php echo $fedex_status; ?>" id="ec_admin_fedex_status">
        	<?php if( $fedex_status == 'connected' ){ echo 'Connected'; }else if( $fedex_status == 'error' ){ echo 'Error'; }else{ echo 'Disabled'; } ?>
        </div>
    </div>
    
</div>