<div class="brid-wp-content">
	<script>
		var siteNum = <?php echo count($sites); ?>;
	</script>
	
	<?php if( empty($sites) ): ?>

		<div style="margin-top:20px;">
			<p>No sites, please visit our <a href="https://cms.brid.tv" target="_blank">CMS</a> and add website.</p>
			<p>Please <a href="#" class="unauthorizeBrid" style="color:#000; font-size:14px;">Unauthorize account</a> and try again</p>
          
		</div>
		<script>
			//Used in callback on save -> partnerCreateSnapshot
			var settingsUrl = "<?php echo admin_url('options-general.php?page=brid-video-config'); ?>"
		</script>
	<?php else: ?>
		<div id="settings_header_wrapper">
			<!--<?php echo $premium; ?>-->
			<div id="logo<?php echo intval($premium); ?>">
				<div id="clickLogo" title="Go to Brid.tv"></div>
				<!-- <div id="clickPlan" title="Plan explained"></div> -->    
			</div>
			
			<?php if( $premium == 1 ): ?>
				<div class="upgrade">
					<a href="<?php echo OAUTH_PROVIDER."/users/login/?redirect=order"; ?>" target="_blank" >
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="74px" height="18px" viewBox="0 0 74 18" enable-background="new 0 0 74 18" xml:space="preserve"><g><linearGradient id="SVGID_1_" gradientUnits="userSpaceOnUse" x1="0" y1="9" x2="74" y2="9"><stop offset="0" stop-color="#FF3B00"/><stop offset="1" stop-color="#FF2A5E"/></linearGradient><path fill="url(#SVGID_1_)" d="M74 12.7c0 2.9-2.4 5.3-5.4 5.3H5.4c-3 0-5.4-2.4-5.4-5.3V5.3C0 2.4 2.4 0 5.4 0h63.2c3 0 5.4 2.4 5.4 5.3V12.7z"/><g><path fill="#FFFFFF" d="M22.6 4.1v5.1c0 1.9 0.9 2.7 2 2.7 1.3 0 2.1-0.8 2.1-2.7V4.1h1.1v5c0 2.6-1.4 3.7-3.3 3.7 -1.8 0-3.1-1-3.1-3.7v-5H22.6z"/><path fill="#FFFFFF" d="M29.8 8.6c0-0.8 0-1.4-0.1-2h1l0.1 1.1h0c0.5-0.8 1.2-1.2 2.2-1.2 1.5 0 2.7 1.3 2.7 3.1 0 2.2-1.4 3.3-2.8 3.3 -0.8 0-1.6-0.4-1.9-1h0v3.3h-1.1V8.6zM30.9 10.2c0 0.2 0 0.3 0.1 0.5 0.2 0.8 0.9 1.3 1.7 1.3 1.2 0 1.9-1 1.9-2.4 0-1.2-0.7-2.3-1.9-2.3 -0.8 0-1.5 0.5-1.7 1.4 0 0.1-0.1 0.3-0.1 0.5V10.2z"/><path fill="#FFFFFF" d="M42.6 6.6c0 0.4-0.1 0.9-0.1 1.7v3.6c0 1.4-0.3 2.3-0.9 2.8 -0.6 0.6-1.5 0.7-2.3 0.7 -0.8 0-1.6-0.2-2.1-0.5l0.3-0.9c0.4 0.3 1.1 0.5 1.8 0.5 1.2 0 2-0.6 2-2.1v-0.7h0c-0.3 0.6-1 1-2 1 -1.6 0-2.7-1.3-2.7-3 0-2.1 1.4-3.3 2.8-3.3 1.1 0 1.7 0.6 2 1.1h0l0.1-0.9H42.6zM41.4 9c0-0.2 0-0.4-0.1-0.5 -0.2-0.6-0.8-1.2-1.6-1.2 -1.1 0-1.9 0.9-1.9 2.3 0 1.2 0.6 2.2 1.8 2.2 0.7 0 1.3-0.4 1.6-1.1 0.1-0.2 0.1-0.4 0.1-0.6V9z"/><path fill="#FFFFFF" d="M44.3 8.5c0-0.7 0-1.3-0.1-1.9h1l0 1.2h0.1c0.3-0.8 1-1.3 1.7-1.3 0.1 0 0.2 0 0.3 0v1.1c-0.1 0-0.2 0-0.4 0 -0.8 0-1.4 0.6-1.5 1.4 0 0.2-0.1 0.3-0.1 0.5v3.3h-1.1V8.5z"/><path fill="#FFFFFF" d="M52 12.7l-0.1-0.8h0c-0.3 0.5-1 0.9-1.9 0.9 -1.3 0-1.9-0.9-1.9-1.8 0-1.5 1.3-2.3 3.8-2.3V8.7c0-0.5-0.1-1.4-1.4-1.4 -0.6 0-1.2 0.2-1.6 0.5L48.5 7c0.5-0.3 1.3-0.5 2.1-0.5 1.9 0 2.4 1.3 2.4 2.5v2.3c0 0.5 0 1.1 0.1 1.5H52zM51.8 9.6c-1.2 0-2.7 0.2-2.7 1.4 0 0.7 0.5 1.1 1.1 1.1 0.8 0 1.3-0.5 1.5-1 0-0.1 0.1-0.2 0.1-0.4V9.6z"/><path fill="#FFFFFF" d="M60.1 3.7v7.4c0 0.5 0 1.2 0.1 1.6h-1l-0.1-1.1h0c-0.3 0.7-1.1 1.2-2.1 1.2 -1.5 0-2.7-1.3-2.7-3.1 0-2 1.3-3.3 2.8-3.3 1 0 1.6 0.4 1.9 0.9h0V3.7H60.1zM59 9.1c0-0.1 0-0.3-0.1-0.5 -0.2-0.7-0.8-1.3-1.6-1.3 -1.2 0-1.9 1-1.9 2.4 0 1.2 0.6 2.3 1.9 2.3 0.8 0 1.5-0.5 1.7-1.3 0-0.2 0.1-0.3 0.1-0.5V9.1z"/><path fill="#FFFFFF" d="M62.7 9.8c0 1.5 1 2.1 2.1 2.1 0.8 0 1.3-0.1 1.7-0.3l0.2 0.8c-0.4 0.2-1.1 0.4-2.1 0.4 -1.9 0-3.1-1.2-3.1-3.1 0-1.9 1.1-3.3 2.9-3.3 2 0 2.6 1.8 2.6 2.9 0 0.2 0 0.4 0 0.5H62.7zM66 9c0-0.7-0.3-1.8-1.6-1.8 -1.2 0-1.7 1-1.7 1.8H66z"/></g><path fill="#FFFFFF" d="M17.3 9.7c-0.1 0-0.2 0-0.3-0.1l-5.2-5.1L6.5 9.6c-0.2 0.2-0.4 0.2-0.6 0C5.8 9.5 5.8 9.2 5.9 9l5.5-5.4c0.2-0.2 0.4-0.2 0.6 0L17.6 9c0.2 0.2 0.2 0.4 0 0.6C17.5 9.7 17.4 9.7 17.3 9.7z"/><path fill="#FFFFFF" d="M6.2 13.7c-0.1 0-0.2 0-0.3-0.1 -0.2-0.2-0.2-0.4 0-0.6l5.5-5.4c0.2-0.2 0.4-0.2 0.6 0l5.5 5.4c0.2 0.2 0.2 0.4 0 0.6 -0.2 0.2-0.4 0.2-0.6 0l-5.2-5.1 -5.2 5.1C6.4 13.7 6.3 13.7 6.2 13.7z"/></g></svg>
					</a>
				</div>
			<?php endif; ?>

			<div id="plan-premium">
                
                  <table class="plan-premium-table">
                        <tbody><tr>
                          <td colspan="2">
                            <div class="plan-info-top">
                            Free plan
                             <div class="stiklir right"></div>
                            </div>
                          </td>
                        </tr>
                        <tr>
                          <td>
                            <span>HTML5 Player with Flash fallback</span><br>

                            Powerfull JavaScript API<br>
                            33+ professionally designed skins<br>
                            Intelligent site skinning<br>
                            Responsive sizing<br>
                            Social sharing options<br>
                            VEEPS voip/chatplay plugin (exclusive)
                          </td>
                          <td>
                            <span>Full content management solution</span><br>
                            Google powered analytics<br>
                            Dynamic and Custom playlist support<br>
                            Wordpress plugin<br>
                            Youtube syndication
                          </td>
                        </tr>
                        <tr>
                          
                          <td colspan="2">
                            <span style="margin-top:15px;">You are free to monetize our player</span><br>
                            Pre-roll, mid-roll, post-roll and overlay, VAST and VPAID support, Flash and HTML5 ads
                          </td>
                        </tr>
                        <tr>
                          <td colspan="2">
                            <div class="plan-info-top" style="margin-top:15px;">
                              Enterprise plan
                               <div class="stiklir right"></div>
                            </div>
                          </td>
                        </tr>
                        <tr>
                          <td>
                            <span>Unlimited Encoding.com video encoding</span><br>
                            Virtually all formats supported with the fastest turnaround times<br>
                            Optimized playback accross all Android, iOS, web platforms:<br>
                            your videos will work everywhere<br>
                            No file duration restrictions<br>
                            HD video renditions supported<br>
                            Unlimited number of file uploads<br>
                            Upload up to 1 GB files<br>
                          </td>
                          <td style="padding-top:28px">
                            Whitelisted and approved social sharing links via https<br>
                            Unique customized skins and intro videos<br>
                            24/7 support<br>
                            HTML5 interactive ads support<br>
                            You receive <b>minimum 60% of revenue share</b><br>
                            
                          </td>
                        </tr>
                      </tbody></table>    
			</div>
			<div id="plan-free">
                
                  <table class="plan-premium-table">
                        <tbody><tr>
                          <td colspan="2">
                            <div class="plan-info-top">
                            Free plan
                            <div class="stiklir right"></div>
                            </div>
                          </td>
                        </tr>
                        <tr>
                          <td>
                            <span>HTML5 Player with Flash fallback</span><br>

                            Powerfull JavaScript API<br>
                            33+ professionally designed skins<br>
                            Intelligent site skinning<br>
                            Responsive sizing<br>
                            Social sharing options<br>
                            VEEPS voip/chatplay plugin (exclusive)
                          </td>
                          <td>
                            <span>Full content management solution</span><br>
                            Google powered analytics<br>
                            Dynamic and Custom playlist support<br>
                            Wordpress plugin<br>
                            Youtube syndication
                          </td>
                        </tr>
                        <tr>
                          
                          <td colspan="2">
                            <span style="margin-top:15px;">You are free to monetize our player</span><br>
                            Pre-roll, mid-roll, post-roll and overlay, VAST and VPAID support, Flash and HTML5 ads
                          </td>
                        </tr>
                        <tr>
                          <td colspan="2">
                            <div class="plan-info-top" style="margin-top:15px;background:#F21F03">
                              Enterprise plan
                              <div class="upgradeBrid right"></div>
                            </div>
                          </td>
                        </tr>
                        <tr>
                          <td>
                            <span>Unlimited Encoding.com video encoding</span><br>
                            Virtually all formats supported with the fastest turnaround times<br>
                            Optimized playback accross all Android, iOS, web platforms:<br>
                            your videos will work everywhere<br>
                            No file duration restrictions<br>
                            HD video renditions supported<br>
                            Unlimited number of file uploads<br>
                            Upload up to 1 GB files<br>
                          </td>
                          <td style="padding-top:28px">
                            Whitelisted and approved social sharing links via https<br>
                            Unique customized skins and intro videos<br>
                            24/7 support<br>
                            HTML5 interactive ads support<br>
                            You receive <b>minimum 60% of revenue share</b><br>
                            
                          </td>
                        </tr>
                        <tr>
                        <td colspan="2" style="padding-bottom:0px">
                          <div class="bridButton">
                            <div class="buttonLargeContent" id="upgradeMe" style="font-family:'Fjalla One' Arial; float:right; font-size:16px" data-action="askQuestion" href="<?php echo admin_url('admin-ajax.php').'?action=askQuestion'; ?>">UPGRADE PLAN</div>
                          </div>
        
                          <script>jQuery('#upgradeMe').colorbox({innerWidth:920, innerHeight:650});</script>
                          </td>
                      </tr>
                      </tbody></table>
			</div>
		</div> <!-- #settings_header_wrapper -->
		
		<script type="text/javascript">
			var partnerUpload = <?php echo intval($premium); ?>;
			jQuery('#clickLogo').click(function() {
				window.open('https://cms.brid.tv', '_blank');
			})
			
			jQuery('#clickPlan, .plan-info-close').on('click', function() {
                
				//if(Object.keys(Partner).length>0){
				var boxToShow = 'free';
				if( partnerUpload != 1 ) {
					boxToShow = 'premium';
				}
				if( !jQuery('#plan-'+boxToShow ).is(':visible'))
					jQuery('#plan-'+boxToShow).show();
				else
					jQuery('#plan-'+boxToShow).hide();
               // }
			});
		</script>

		<?php if(!function_exists('curl_version')): ?>
		<div class="mainWrapper" style="width:75%;">
			<p class="bridNotice">
				<img src="<?php echo BRID_PLUGIN_URL.'/img/warn.png'; ?>" style="position: relative; top: 1px; margin-right: 5px;"alt="Warning"/> Your webserver is not properly configured to use the Brid plugin. Please install/enable cURL on your server before proceeding.

			</p>
		</div>
		<?php endif; ?>
		
		<div class="mainWrapper" style="width:100%;position:relative; top:20px">
			
			<div class="mainWrapper mainWrapperInner">
				<form method="post" action="admin.php?page=brid-video-config" id="bridSettingsForm">
					<div class="tabs">
						<div id="Settings" class="tab">SETTINGS</div>
						<div id="Player" class="tab-inactive">PLAYER</div>
						<?php if( $user->Plan->permissions->outstream == 1 ): ?>
						<div id="Outstream" class="tab-inactive">OUTSTREAM AD</div>
						<?php endif;?>
					</div>
              		
					<div id="Settings-content" class="brid-tab-content settingsWrapper" style="display:block;">
	                
						<?php settings_fields('brid_options');  ?>
	                   
						<input type="hidden" name="brid_options[oauth_token]" value="<?php echo $oAuthToken; ?>"/>
						<input type="hidden" name="brid_options[user_id]" value="<?php echo $user_id; ?>"/>
						<input type="hidden" id="width" name="brid_options[width]" value="<?php echo $width; ?>"/>
						<input type="hidden" id="height" name="brid_options[height]" value="<?php echo $height; ?>"/>
						<input type="hidden" id="autoplay" name="brid_options[autoplay]" value="<?php echo $autoplay; ?>"/>
						<input type="hidden" id="PartnerId" name="Partner[id]" value="<?php echo $selected; ?>"/>
						<input type="hidden" id="defaultChannelHidden" name="brid_options[default_channel]" />
						<input type="hidden" id="videoImageHidden" name="brid_options[video_image] " />
						
						<div class="settings-section-title">
							<div class="settings-section-title-text">CHOOSE SITE</div>
							<div class="settings-section-title-line"></div>
						</div>
						            
	                    <select id="sites" name="brid_options[site]" class="chzn-select" style="width:100%;">
						<?php
							if( !empty($sites) ) {
	
								foreach($sites as $k => $v) {
									$s = '';
									if( $selected == '' ) {
										$selected = $k;
									}
									if( $k == $selected ) {
										$s = 'SELECTED';
									}
									echo '<option value="'.$k.'" '.$s.'>'.$v.'</option>';
								}
							}
	                    ?>
	                    </select>
	        
						<div class="flashFalbackWarring" style="margin-left:10px">
							All your content on Brid will be managed under this site/account. To add more sites, please <a href="https://cms.brid.tv" target='_blank'>login to BridTv</a>.
						</div>
	                    
						<?php
						//Show preview player in visual editor
						BridHtml::checkbox(array(
	
							'id'=>'visual',
							'name'=>'brid_options[visual]',
							'value'=>$visual_preview,
							'marginBottom' => 0,
							'marginTop' => 0,
							'title'=> 'SHOW PREVIEW PLAYER IN VISUAL EDITOR',
							'desc'=>'If enabled, will show a preview of the player in your WordPress <a href="https://codex.wordpress.org/Writing_Posts#Visual_Versus_Text_Editor" target="_blank">Visual tab</a> on posts or pages. (May add additional paragraph tags depending on used theme)'
	
						));
						//Override default video embed
						BridHtml::checkbox(array(
	
							'id'=>'ovr_def',
							'name'=>'brid_options[ovr_def]',
							'value'=>$override_def_player,
							'marginBottom' => 0,
							'marginTop' => 0,
							'title'=> 'REPLACE DEFAULT PLAYER WITH BRID PLAYER',
							'desc'=>'Will try to replace all WordPress default video tags with the BridTv player. All players successfully replaced will be automatically monetized with your Ad Tag URL that you set on the <a href="#" class="monetizeTabPage">Brid settings page</a>. <a href="https://brid.zendesk.com/hc/en-us/articles/202733772" target="_blank">Learn more</a>.'
	
						));
						
						BridHtml::checkbox(array(
								'id'=>'async_embed',
								'name'=>'brid_options[async_embed]',
								'value'=>$async_embed,
								'marginBottom' => 0,
								'marginTop' => 0,
								'title'=> 'ENABLE ASYNCHRONOUS EMBED CODE',
								'desc'=>' Check this option if you want your Brid players to load asynchronously on your web pages.'
						));
						//Override defualt YT embed
						/*BridHtml::checkbox(array(
	
							'id'=>'ovr_yt',
							'name'=>'brid_options[ovr_yt]',
							'value'=>$override_youtube,
							'marginBottom' => 0,
							'marginTop' => 0,
							'title'=> 'REPLACE YOUTUBE LINKS WITH BRID PLAYER',
							'desc'=>'Will try to replace all YouTube video tags with the BridTv player. All players successfully replaced will be automatically monetized with your Ad Tag URL that you set on the <a href="#" class="monetizeTabPage">Brid settings page</a>. <a href="https://brid.zendesk.com/hc/en-us/articles/202733772" target="_blank">Learn more</a>.'
	
						));*/
	
						?>  
	                    
						<div id="defaultChannel" style="display:<?php echo !empty($players) ? 'block;' : 'none'; ?>">
							<div class="selectText">Choose default category</div>
	
							<select id="defaultChannelSelect" name="brid_option[defaultChannel]" class="chzn-select" style="width:100%;">
								<option value="0">Select category</option>
								<?php
								foreach($channels as $k=>$v):
									$selected = '';
									if( $v->Channel->id == $defaultChannel ) {
										$selected = 'selected="selected"';
									}
								?>
								<option value="<?php echo $v->Channel->id; ?>" <?php echo $selected; ?>><?php echo $v->Channel->name; ?></option>
								<?php endforeach; ?>
	                                
							</select>
	                                
						</div>
	
						<table style="width:100%;margin-top:20px;">
							<tr>
								<td>
									<input type="hidden" name="thumbnail" id="VideoThumbnail">
									<div class="input text">
										<div class="selectText">Choose default Snapshot Url</div>
										<input name="image" placeholder="Snapshot URL" data-info="Provide URL to the snapshot image" tabindex="5" maxlength="300" type="text" id="VideoImage" class="defaultSnap" value="<?php echo BridOptions::getOption('video_image'); ?>">
									</div>
								</td>
								<td style="width:110px">
									<div class="bridBrowseLibaryImg" style="margin-top:23px;" data-field="VideoImage" data-uploader_button_text="Add Snapshot" data-uploader_title="Browse from Media Library">BROWSE LIBRARY</div>
								</td>
							</tr>
						</table>
	             
	            	</div><!-- #Settings-content -->
            
					<div id="Outstream-content" class="brid-tab-content settingsWrapper" style="display:none;">
		         
						<div class="settings-section-title">
							<div class="settings-section-title-text">CHOOSE UNIT</div>
							<div class="settings-section-title-line"></div>
							<input name="Unit[id]" type="hidden" value="<?php echo $defaultOutstreamUnit->Unit->id?>" id="UnitId" required="required">
						</div>
						
						<select id="unitSelected" name="brid_options[unit]" class="chzn-select" style="width: 100%;"></select>
						
						<div class="settings-section-title">
							<div class="settings-section-title-text">DEFAULT UNIT OPTIONS</div>
							<div class="settings-section-title-line"></div>
						</div>
						
						<div class="form form-flex-row">
							<div class="input-label required">
								<label for="UnitWidth">Width</label>
								<input name="Unit[width]" placeholder="Unit Width" maxlength="10" type="text" value="<?php echo $unitWidth; ?>" id="UnitWidth" required="required">
							</div>
							<div class="xX"></div>
							<div class="input-label required">
								<label for="UnitHeight">Height</label>
								<input name="Unit[height]" placeholder="Unit Height" maxlength="10" type="text" value="<?php echo $unitHeight; ?>" id="UnitHeight" required="required">
							</div>
						</div>
						
						<div class="checkboxRowSettings" style="padding-top: 20px; margin-top: 0px; margin-bottom:0px;">
							<div id="checkbox-UnitAutoplayInview" class="bridCheckbox" data-method="toggleUnitAutoplayInviewOptions"  data-name="UnitAutoplayInview">
								<div class="checkboxContent">
									<img src="<?php echo BRID_PLUGIN_URL; ?>img/checked.png" class="checked" style="display:none" alt="">
									<input type="hidden" name="Unit[autoplayInview]" class="singleCheckbox" id="UnitAutoplayInview" value="0" data-value="0" style="display:none;">
								</div>
								<div class="checkboxText">SHOW WHEN 50% IN VIEW</div>
							</div>
						</div>
						
						<div class="checkboxRowSettings" style="padding-left: 35px; padding-top: 15px; margin-top: 0px; margin-bottom:0px;">
							<div id="checkbox-UnitPauseOffView" class="bridCheckbox" data-name="UnitPauseOffView">
								<div class="checkboxContent">
									<img src="<?php echo BRID_PLUGIN_URL; ?>img/checked.png" class="checked" style="display:none" alt="">
									<input type="hidden" name="Unit[pauseOffView]" class="singleCheckbox" id="UnitPauseOffView" value="0" data-value="0" style="display:none;">
								</div>
								<div class="checkboxText">PAUSE AD WHEN OUT OF VIEW</div>
							</div>
						</div>
						
						<div class="checkboxRowSettings" style="padding-left: 35px; padding-top: 15px; margin-top: 0px; margin-bottom:0px;">
							<div id="checkbox-UnitViewability" class="bridCheckbox" data-name="UnitViewability">
								<div class="checkboxContent">
									<img src="<?php echo BRID_PLUGIN_URL; ?>img/checked.png" class="checked" style="display:none" alt="">
									<input type="hidden" name="Unit[viewability]" class="singleCheckbox" id="UnitViewability" value="0" data-value="0" style="display:none;">
								</div>
								<div class="checkboxText">FAVOR VIEWABILITY OVER FILL RATE</div>
							</div>
						</div>
						
						<div class="checkboxRowSettings" style="padding-top: 20px; margin-top: 0px; margin-bottom:0px;">
							<div id="checkbox-UnitStartMuted" class="bridCheckbox" data-method="toggleUnitStartMuted"  data-name="UnitStartMuted">
								<div class="checkboxContent">
									<img src="<?php echo BRID_PLUGIN_URL; ?>img/checked.png" class="checked" style="display:none" alt="">
									<input type="hidden" name="Unit[start_muted]" class="singleCheckbox" id="UnitStartMuted" value="0" data-value="0" style="display:none;">
								</div>
								<div class="checkboxText">START VIDEOS WITH SOUND MUTED</div>
							</div>
						</div>
						
						<div class="checkboxRowSettings" style="padding-left: 35px; padding-top: 15px; margin-top: 0px; margin-bottom:0px;">
							<div id="checkbox-UnitStartMutedRollover" class="bridCheckbox" data-name="UnitStartMutedRollover">
								<div class="checkboxContent">
									<img src="<?php echo BRID_PLUGIN_URL; ?>img/checked.png" class="checked" style="display:none" alt="">
									<input type="hidden" name="Unit[start_muted_rollover]" class="singleCheckbox" id="UnitStartMutedRollover" value="0" data-value="0" style="display:none;">
								</div>
								<div class="checkboxText">PLAY SOUND ON MOUSE ROLLOVER</div>
							</div>
						</div>
						
						<div class="checkboxRowSettings" style="padding-top: 20px; margin-top: 0px; margin-bottom:0px;">
							<div id="checkbox-UnitSlideInview" class="bridCheckbox" data-name="UnitSlideInview">
								<div class="checkboxContent">
									<img src="<?php echo BRID_PLUGIN_URL; ?>img/checked.png" class="checked" style="display:none" alt="">
									<input type="hidden" name="Unit[slide_inview]" class="singleCheckbox" id="UnitSlideInview" value="0" data-value="0" style="display:none;">
								</div>
								<div class="checkboxText">MAKE PLAYER STICKY</div>
							</div>
						</div>
						
						<!--
						<div class="checkboxRowSettings" style="padding-top: 20px; margin-top: 0px; margin-bottom: 0px; padding-bottom: 10px;">
							<div id="checkbox-UnitFlashFallback" class="bridCheckbox" data-name="UnitFlashFallback">
								<div class="checkboxContent">
									<img src="<?php echo BRID_PLUGIN_URL; ?>img/checked.png" class="checked" style="display:none" alt="">
									<input type="hidden" name="Unit[flash_fallback]" class="singleCheckbox" id="UnitFlashFallback" value="0" data-value="0" style="display:none;">
								</div>
								<div class="checkboxText">FORCE FLASH ON DESKTOP</div>
							</div>
						</div>
						-->
						
						<!-- OUTSTREAM UNIT MONETIZE -->
						<div class="settings-section-title" style="margin-bottom: 20px;"> 
							<div class="settings-section-title-text">MONETIZE</div>
							<div class="settings-section-title-line"></div>
						</div>
						
						<div class="selectText">Choose Ad Parser</div>
						<select id="unitParser" name="Unit[parser]" class="chzn-select" style="width: 100%;">
							<?php 
							foreach ( array('optimized' => 'Brid SDK', 'ima' => 'GOOGLE IMA SDK') as $k=>$v ) {
								$s = '';
								if( $defaultOutstreamUnit->Unit->parser == $k ) {
									$s = 'selected';
								}
								echo '<option value="'.$k.'" '.$s.' >'.$v.'</option>';
							}
							?>
						</select>
						
						<div style="display: flex;">
							<div class="bridButton add-preroll-ad" id="add-unit-preroll" style="margin-top: 20px;">
								<div class="buttonLargeContent">ADD PRE-ROLL</div>
							</div>
						</div>
						
						<div id="unitPrerollBox" class="form" style="width: 100%; margin-top: 20px; padding-bottom: 20px;">
						
						</div>
						
						<!-- OUTSTREAM UNIT MONETIZE -->
						
						<!-- OUTSTREAM UNIT COMSCORE -->
						<div class="settings-section-title" style="margin-bottom: 0px;"> 
							<div class="settings-section-title-text">SET COMSCORE</div>
							<div class="settings-section-title-line"></div>
						</div>
						<div class="settingsRow form">
							<div class="selectText">COMSCORE ID</div>
							<input type="text" placeholder="ComScore ID" name="Unit[comscore]" value="<?php echo ($defaultOutstreamUnit != null) ? $defaultOutstreamUnit->Unit->comscore : ''; ?>" maxlength="1024" />
						</div>
						<!-- OUTSTREAM UNIT COMSCORE -->
						
					</div><!-- #Outstream-content -->

					<!-- #Player-content START -->
					<div id="Player-content" class="brid-tab-content settingsWrapper" style="display:none;">
						<div id="playerList" style="display:block">
							
							<div class="settings-section-title">
								<div class="settings-section-title-text">CHOOSE PLAYER</div>
								<div class="settings-section-title-line"></div>
							</div>

							<!-- fill this selectbox via ajax -->
							<select id="playerListSelect" name="brid_options[player]" class="chzn-select2" style="width:100%;">
		                       
							</select>
							<div class="flashFalbackWarring" style="margin-left: 10px">
								All your video content will be played through the selected player. 
								To add more players, please <a href="https://cms.brid.tv" target='_blank'>login to BridTv</a>.
							</div>
						</div>
						<table style="margin-top: 15px; width: 100%;">
							<tr>
								<td style="width:100%; vertical-align: top;" colspan="2">
									<div class="settings-section-title">
										<div class="settings-section-title-text">CHOOSE SKIN</div>
										<div class="settings-section-title-line"></div>
									</div>
								</td>
							</tr>
		
							<tr>
								<td style="width:50%; vertical-align: top;" >
		
									<input name="Skin[templatized]" type="hidden" value="0" id="SkinTemplatized" required="required">
									<input name="Player[id]" type="hidden" value="0" id="PlayerId" required="required">
		
									<div id="inteligentSkinMsg" style="margin-bottom: 15px;display:none;">
										Detected skin on this player is an 
										<a href="https://brid.zendesk.com/hc/en-us/articles/200299471" target="_blank">intelligent skin</a>. 
										To change the skin used on this player please change it via 
										<a href="https://cms.brid.tv" target="_blank">Brid CMS</a>.
									</div>
		
									<div id="skinList" style="display:<?php echo !empty($players) ? 'block;' : 'none'; ?>width: 95%;">
		
										<select id="playerSkinSelect" name="Player[skin_id]" class="chzn-select2" style="width:100%;">
											<?php
											if(!empty($skins)) {
												$n = count($skins);
		                                   
												foreach($skins as $k=>$v) {
													$s = '';
													//$v->Skin->id==$skinSelected || 
													if($n==1) {
														$s = 'SELECTED';
													}
													echo '<option value="'.$v->Skin->id.'" '.$s.'>'.$v->Skin->name.'</option>';
												}
		
											}
											?>
										</select>
										<div class="flashFalbackWarring" style="margin-left:10px">
											Choose one of the many custom designed player skins.
										</div>
									</div>
									<div class="form" style="width:auto">
										<!-- Player size -->
										<table style="width:300px;margin-top:20px;">
										<tbody>
											<tr>
												<td>
													<div class="input text required">
														<label for="PlayerWidth">Width</label>
														<input name="Player[width]" default-value="Width" data-info="Width" maxlength="10" type="text" value="<?php echo $width; ?>" id="PlayerWidth" required="required">
														<div class="defaultInputValue" data-info="Width" style="padding-top: 0px; display: none; top: 37px; padding-left: 5px; font-size: 16px;" id="default-value-PlayerWidth" data-position="true">Width</div>
													</div>
												</td>
												<td class="xTD"><div class="xX"></div></td>
												<td>
													<div class="input text required">
														<label for="PlayerHeight">Height</label>
														<input name="Player[height]" default-value="Height" data-info="Height" maxlength="10" type="text" value="<?php echo $height; ?>" id="PlayerHeight" required="required">
														<div class="defaultInputValue" data-info="Height" style="padding-top: 0px; display: none; top: 37px; padding-left: 5px; font-size: 16px;" id="default-value-PlayerHeight" data-position="true">Height</div>
													</div>
												</td>
											</tr>
										</tbody>
										</table>
										<!-- Player options -->
									</div>
		
									<?php
		
									BridHtml::checkbox(array(
		
										'id'=>'PlayerAspect',
										'name'=>'brid_options[aspect]',
										'value'=>$aspect,
										'method'=>'togglePlayerSize',
										'title'=> 'FIT PLAYER SIZE TO POST',
										'marginBottom'=>0,
										'marginTop'=>0,
										'desc'=>'If enabled, the Brid player will fit your post width and retain it\'s aspect ratio.<br/>This option will override your player width and height settings.'
		
									));
		
									?>
		                              
									<div class="checkboxRowSettings" style="padding-top: 20px; margin-top: 0px; margin-bottom:0px;">
										<div id="checkbox-PlayerAutoplay" class="bridCheckbox" data-method="toggleAutoplayOptions"  data-name="PlayerAutoplay">
											<div class="checkboxContent">
												<img src="<?php echo BRID_PLUGIN_URL; ?>img/checked.png" class="checked" style="display:none" alt="">
												<input type="hidden" name="Player[autoplay]" class="singleCheckbox" id="PlayerAutoplay" value="0" data-value="0" style="display:none;">
											</div>
											<div class="checkboxText">AUTOPLAY</div>
										</div>
									</div>
		      						
									<div class="divAsRow" style="padding-left: 35px; padding-bottom: 10px;">
										<div class="checkboxRowSettings disabledCheckbox" style="padding-top: 10px; margin-top: 0px; margin-bottom: 0px;">
											<div id="checkbox-PlayerAutoplayInview" class="bridCheckbox disabledCheckbox" data-name="PlayerAutoplayInview">
												<div class="checkboxContent">
													<img src="<?php echo BRID_PLUGIN_URL; ?>img/checked.png" class="checked" style="display:none" alt="">
													<input type="hidden" name="Player[autoplayInview]" class="singleCheckbox" id="PlayerAutoplayInview" value="0" data-value="0" style="display:none;">
												</div>
												<div class="checkboxText">
													Only when 50% in view<a href="https://www.brid.tv/autoplay-50-in-view/" target="_blank" class="demoLink"></a>
												</div>
								     
											</div>
										</div>
									</div>
									
									<div class="divAsRow" style="padding-left: 35px; padding-bottom: 10px;">
										<div class="checkboxRowSettings disabledCheckbox" style="padding-top: 10px; margin-top: 0px; margin-bottom: 0px;">
											<div id="checkbox-PlayerAutoplayOnAd" class="bridCheckbox disabledCheckbox" data-name="PlayerAutoplayOnAd">
												<div class="checkboxContent">
													<img src="<?php echo BRID_PLUGIN_URL; ?>img/checked.png" class="checked" style="display:none" alt="">
													<input type="hidden" name="Player[autoplay_on_ad]" class="singleCheckbox" id="PlayerAutoplayOnAd" value="0" data-value="0" style="display:none;">
												</div>
												<div class="checkboxText">
													If ad is present
												</div>
											</div>
										</div>
									</div>
		                              
									<?php 
		                              
										//Player[start_muted]
										/*BridHtml::checkbox(array(
		
											'id'=>'PlayerStartMuted',
											'name'=>'Player[start_muted]',
											'value'=>$player->start_muted,
											'title'=> 'START MUTED',
											'marginTop' => '0',
											'desc'=>'Start videos with sound muted.'
		
										));*/
									?>
									
									<div class="settingsRow form">
										<label for="StartVolume" class="checkboxText" style="margin-left: 0px; display: block;">START VOLUME</label>
										<input name="Player[start_volume]" style="width: 120px;" default-value="StartVolume" data-info="StartVolume" maxlength="10" type="text" value="<?php echo $player->start_volume; ?>" id="StartVolume">
									</div>
									
									<div class="settingsRow form">
										<label for="HoverVolume" class="checkboxText" style="margin-left: 0px; display: block;">MOUSE ROLLOVER VOLUME</label>
										<input name="Player[hover_volume]" style="width: 120px;" default-value="HoverVolume" data-info="HoverVolume" maxlength="10" type="text" value="<?php echo $player->hover_volume; ?>" id="HoverVolume">
									</div>
		                             
									<!-- Veeps -->
									<!--  
									<div class="checkboxRowSettings" style="margin-top:0px; margin-bottom:0px; padding-top: 20px;">
										<div class="bridCheckbox" id="checkbox-voipSocEnabled" data-method="toggleVoipSocialOptions" data-name="voipSocEnabled">
											<div class="checkboxContent">
												<img src="<?php echo BRID_PLUGIN_URL; ?>/img/checked.png" class="checked" style="display:none" alt="">
												<input type="hidden" name="Player[voipSocEnabled]" class="singleCheckbox" id="voipSocEnabled" data-value="<?php echo $player->voipSocEnabled; ?>" style="display:none;">
											</div>
											<div class="checkboxText" id="checkbox-voipSocEnabled">
												<div class="veepsLogo"></div>  
												<span style="top: -5px;text-transform: uppercase; margin: 0;;position:relative;top:-5px;" class="checkboxText"> VEEPS VIDEO AND CHAT PLUG-IN <a href="https://www.brid.tv/veeps-demo/" target="_blank" class="demoLink"></a></span>
											</div> 
										</div>
									</div>
		                             
		
									<div class="divAsRow" style="padding-left:35px; padding-bottom: 10px;">
										<div class="checkboxRowSettings" style="margin: 0px; padding-top: 10px;">
											<div class="bridCheckbox disabledCheckbox" id="checkbox-veepsChat" data-name="veepsChat" style="margin-top:4px;">
												<div class="checkboxContent">
													<img src="<?php echo BRID_PLUGIN_URL; ?>/img/checked.png" class="checked" style="display:none" alt="">
													<input type="hidden" name="Player[veepsChat]" class="singleCheckbox" id="veepsChat" data-value="<?php echo $player->veepsChat; ?>" style="display:none;">
												</div>
												<div class="checkboxText" id="checkbox-veepsChat">Display video for user portraits</div>
											</div>
										</div>
										
										<div class="checkboxRowSettings"  style="margin: 0px; padding-top: 10px;">
											<div class="bridCheckbox disabledCheckbox" id="checkbox-veepsType" data-method="toggleVeepsChatNextToPlayer" data-name="veepsType" style="margin-top:4px;text-transform:none;">
												<div class="checkboxContent"><img src="<?php echo BRID_PLUGIN_URL; ?>/img/checked.png" class="checked" style="display:none" alt="">
													<input type="hidden" name="Player[veepsType]" class="singleCheckbox" id="veepsType" data-value="<?php echo $player->veepsType; ?>" style="display:none;">
												</div>
												<div class="checkboxText" id="checkbox-veepsType">Launch chat next to video player</div>
											</div>
		                                </div>
		
										<div class="checkboxRowSettings" style="margin: 0px; padding-top: 10px;">
											<div class="bridCheckbox disabledCheckbox" id="checkbox-veepsInit" data-name="veepsInit" style="margin-top:4px; text-transform:none; left:15px;">
												<div class="checkboxContent">
													<img src="<?php echo BRID_PLUGIN_URL; ?>/img/checked.png" class="checked" style="display:none" alt="">
													<input type="hidden" name="Player[veepsInit]" class="singleCheckbox" id="veepsInit" data-value="<?php echo $player->veepsInit; ?>" style="display:none;">
												</div>
												<div class="checkboxText" id="checkbox-veepsInit">Launch chat on "play" click</div>
											</div>
										</div>  
		
									</div>
		                            --> 
									<?php 
									$dis = '';
									if( $user->Plan->permissions->inpage == 0 ) { 
										$dis = "disabledCheckbox paidBlocked";
									} 
									?>
									
									<div class="checkboxRowSettings" style="margin:0px; padding-top: 20px; padding-bottom: 10px;">
										<div class="bridCheckbox <?php echo $dis; ?>" id="checkbox-inpage_mobile_clicktoplay" data-name="inpage_mobile_clicktoplay">
											<div class="checkboxContent">
												<img src="<?php echo BRID_PLUGIN_URL; ?>/img/checked.png" class="checked" style="display:none" alt="">
												<input type="hidden" name="Player[inpage_mobile_clicktoplay]" class="singleCheckbox" id="inpage_mobile_clicktoplay" data-value="0" style="display:none;">
											</div>
											<div class="checkboxText">PLAY IN-PAGE ON iOS <!--<a href="https://www.brid.tv/play-inpage-on-mobile" target="_blank" class="demoLink"></a>--></div>
			                                
										</div>
										<?php if( $user->Plan->permissions->inpage == 0 ) { ?>
											<div class="paidOnly"><a href="<?php echo OAUTH_PROVIDER."/users/login/?redirect=order"; ?>" target="_blank" >
												*Paid plans only</a>.
											</div>
		                                <?php } ?>
									</div>
		                             
									<div class="checkboxRowSettings" style="margin:0px; padding-top: 20px; padding-bottom: 10px;">
										<div class="bridCheckbox" id="checkbox-slide_inview" data-name="slide_inview">
											<div class="checkboxContent">
												<img src="<?php echo BRID_PLUGIN_URL; ?>/img/checked.png" class="checked" style="display:none" alt="">
												<input type="hidden" name="Player[slide_inview]" class="singleCheckbox" id="slide_inview" data-value="<?php echo $player->slide_inview; ?>" style="display:none;">
											</div>
											<div class="checkboxText" id="checkbox-slide_inview">
												STAY IN VIEW <a href="https://www.brid.tv/slide-inview/" target="_blank" class="demoLink"></a>
											</div>
		                                	 
										</div>
									</div>
		                             
		                            <?php 
									$disFb = '';
									if( $user->Plan->permissions->fbfeed == 0 ) { 
										$disFb = "disabledCheckbox paidBlocked";
									} 
									?>
									<!--<div class="checkboxRowSettings" style="margin:0px; padding-top: 20px; padding-bottom: 10px;">
										<div class="bridCheckbox <?php echo $disFb; ?>" id="checkbox-play_in_page" data-method="toggleFb" data-name="play_in_page">
											<div class="checkboxContent">
												<img src="<?php echo BRID_PLUGIN_URL; ?>/img/checked.png" class="checked" style="display:none" alt="">
												<input type="hidden" name="Player[play_in_page]" class="singleCheckbox" id="play_in_page" data-value="<?php echo $player->play_in_page; ?>" style="display:none;">
											</div>
											<div class="checkboxText color-blue-fb">PLAYER ACTS LIKE IN FB NEWS FEED <a href="https://www.brid.tv/page-videos-mobile-autoplay/" target="_blank" class="demoLink"></a></div>
		                                	 
										</div>
										<?php if( $user->Plan->permissions->fbfeed == 0 ): ?>
		                                <div class="paidOnly">
											<a href="<?php echo OAUTH_PROVIDER."/users/login/?redirect=order"; ?>" target="_blank" >
												*Paid plans only.
											</a>
										</div>
										<?php endif; ?>
										<div class="paidOnly" style='<?php if( $user->Plan->permissions->fbfeed == 0 ){ echo "padding-left:4px; margin-top:-2px;"; }?>'>
											<a href="https://www.brid.tv/page-videos-mobile-autoplay/" target="_blank">See demo</a>
										</div>
									</div>-->
									
								</td>
								<td style="vertical-align: top;">
									<div id="bridPlayerPreview">
										<div id="Brid_27449775" class="brid"></div>
									</div>
												
									<div id="createCustomSkin">
										<span>Do you want unique custom made skin?</span><br/>
										Contact us at <a href="mailto:contact@brid.tv?subject=Custom made skin for <?php echo $_SERVER['HTTP_HOST']; ?>">contact@brid.tv</a> so we can make you a custom designed player skin (free of charge) specifically tailored for your site.
									</div>
								</td>
							</tr>
		
						</table>
						
						
						<!-- Monetize -->
						<div class="settings-section-title" style="margin-bottom: 0px;"> 
							<div class="settings-section-title-text">MONETIZE</div>
							<div class="settings-section-title-line"></div>
						</div>
						
						<div id="checkbox-monetize" class="bridCheckbox clearfix" data-method="toggleAdSettings" data-name="monetize" style="margin-top: 20px; margin-bottom: 10px;">
							<?php
								$c = '';
								if( $player->monetize ) {
									$c = 'checked';
								}
		
								$show = ($c=='') ? 'none' : 'block';
							?>
							<div class="checkboxContent">
								<img src="<?php echo BRID_PLUGIN_URL; ?>/img/checked.png" class="checked" style="display:<?php echo $show; ?>" alt="">
		                        
								<input type="hidden" name="Player[monetize]" value="<?php echo $player->monetize; ?>" class="singleCheckbox <?php echo $c; ?>" id="monetize" data-value="<?php echo $player->monetize; ?>" style="display:none;" checked="checked" data-display="block">
							</div>
							<div class="checkboxText">Monetizable</div>
							<div class="flashFalbackWarring" style="margin-left:31px">
								Turn on/off monetization options for this specific player. 
								<a href="https://brid.zendesk.com/hc/en-us/articles/200294232" target="_blank">Learn more</a>.
							</div>
						</div>
		
						
						<div id="monetizationContent">  
		                
							<table class="form-table">
							<tbody>
								<tr>
									<td>
										<div class="formWrapper monetizationOptions" style="display:block;margin:0px;" id="adSettings">
		
											<?php require_once('help_monetize.php'); ?>
		
											<div id="monetAdvancedTitle" style="display: flex; align-items: center; width: 100%; margin-bottom: 20px;">
												<div class="closeAlertDivButton"></div>
												<div class="checkboxText" style="cursor: pointer; margin-left: 10px;">ADVANCED OPTIONS</div>
											</div>
		
											<div id="monetAdvanced" style="display:block;">
		
												<div class="selectText">Choose Ad Parser</div>
												<select id="parser" name="Player[parser]" class="chzn-select" style="width: 100%;">
													<?php 
													foreach ( array('optimized' => 'Brid SDK', 'ima' => 'GOOGLE IMA SDK') as $k=>$v ) {
														$s = '';
														if( $player->parser == $k ) {
															$s = 'selected';
														}
														echo '<option value="'.$k.'" '.$s.' >'.$v.'</option>';
													}
													?>
												</select>
												
												<div class="add-ad-container">
													<div class="add-ad" data-type="preroll">
														<div class="bridButton add-preroll-ad" id="add-preroll-ad" style="opacity: 1;">
															<div class="buttonLargeContent">ADD PRE-ROLL</div>
														</div>
													</div>
			                                  
													<div class="add-ad" id="add-ad-midroll" data-type="midroll">
														<div class="bridButton add-midroll-ad" id="add-midroll-ad" style="opacity: 1;">
															<div class="buttonLargeContent">ADD MID-ROLL / SET CUE POINTS</div>
														</div>
													</div>
			                                  
													<div class="add-ad" data-type="overlay">
														<div class="bridButton add-overlay-ad" id="add-overlay-ad">
															<div class="buttonLargeContent">ADD OVERLAY</div>
														</div>
													</div>
			                                  
													<div class="add-ad" data-type="postroll">
														<div class="bridButton add-postroll-ad" id="add-postroll-ad">
															<div class="buttonLargeContent">POSTROLL</div>
														</div>
													</div>
													
													<?php if( $user->Plan->permissions->banner == 1 ): ?>
													<div class="add-ad" data-type="banner">
														<div class="bridButton add-banner-ad" id="add-banner-ad">
															<div class="buttonLargeContent">300x250 BANNER</div>
														</div>
													</div>
													<?php endif; ?>
												</div>
												
												
												<!-- Content div for ads -->
												<div class="mainWrapper form" style="width:auto">
													<div style="width:100%; margin-top: 20px" id="brid-boxes-content"></div>
												</div>
											</div>
		
										</div>
									</td>
								</tr>
							</tbody>
							</table>
							
						</div> <!-- #monetizationContent -->
						<!-- Monetize -->
						
						
						
						<!-- Comscore -->
						<?php if( $user->Plan->permissions->comscore == 1 ): ?>
						<div class="settings-section-title" style="margin-bottom: 0px;"> 
							<div class="settings-section-title-text">SET COMSCORE</div>
							<div class="settings-section-title-line"></div>
						</div>
						<div class="settingsRow form">
							<div class="selectText">COMSCORE ID</div>
							<input type="text" placeholder="ComScore ID" name="Player[comscore]" value="<?php echo ($player != null) ? $player->comscore : ''; ?>" maxlength="1024" />
						</div>
						<div class="settingsRow form">
							<div class="selectText">COMSCORE C3</div>
							<input type="text" placeholder="ComScore C3" name="Player[c3]" value="<?php echo ($player != null) ? $player->c3 : ''; ?>" maxlength="1024" />
						</div>
						<?php endif; ?>
						<!-- Comscore -->
		
					</div><!-- #Player-content END -->
            
					<div class="propagate">
						<div>Please allow up to 10 minutes for changes to propagate.</div>
						<a href="#" class="unauthorizeBrid">Unauthorize account</a>
					</div> <!-- End Settings Tab -->
            
					<div class="bridButton auth-plugin" data-href="#" id="authPlugin" style="padding-left:10px; margin-top:20px;clear:both;">
						<input type="submit" class="buttonLargeContent" value="SAVE CHANGES"/>
					</div>

			</form>
           
		</div> <!-- End Main Fixed Wrapper 80% -->
			
		<!-- Start News Box -->
		<div class="bridNewsBox bridNewsBoxSmall">
			<div class="bridNewsBoxTitle">FAQ</div>
			<ul id="bridWpNews"></ul>
			<div id="bridBugContent">
				<div id="bridBugIcon"></div>
				<a href="https://brid.zendesk.com/hc/en-us/requests/new" target="_blank" id="bridBugLink">Report a bug</a>
			</div>
		</div>
		<!-- End News Box -->
	</div>
	<!-- End Main Wrapper 100% -->

      
	<?php endif; ?>

	<?php require_once('adBoxes.html'); ?>


<script type="text/javascript">
    
jQuery('#monetAdvancedTitle').on('click', function(e){

	jQuery('#monetAdvanced').fadeToggle(400, function() {

		if(jQuery('#monetAdvanced').is(':visible')) {
			jQuery('.closeAlertDivButton').addClass('closeAlertDivButtonRot');
		} else {
			jQuery('.closeAlertDivButton').removeClass('closeAlertDivButtonRot');
		}
	});

  
});

    //Set white background 
    jQuery('html, body').css('background', '#fff');


    var file_frame = null;
    var playerSelected = '<?php echo $playerSelected; ?>';
    var unitSelected = '<?php echo $selectedUnit; ?>';
    var currentAdCount = 0;
                  // 0 1 2 3
    var adTypes = ['preroll', 'midroll', 'postroll','overlay', 'banner'];


    var ads = <?php echo json_encode(array());?>;
    var unitAds = null;

    initBridMain();
    $Brid.init(['Html.Tabs']);

    jQuery('.unauthorizeBrid').click(function(e){
      e.preventDefault();
      if(confirm("You will not be able to use the BridTv plugin anymore.\nAre you sure you want to unauthorize?"))
      {
       $Brid.Api.call({data : {action : "unauthorizeBrid"}, callback : {after : function(){


          window.location = window.location;

       }}});
      }

    });
    jQuery('input[id$="OverlayStartAt"], input[id$="OverlayDuration"]').off('keypress').on('keypress', $Brid.Util.onlyNumbers);
    jQuery('#PlayerWidth, #PlayerHeight').off('keypress').on('keypress', $Brid.Util.onlyNumbers);

	/**
	 * Ad management - Add AD type click on button
	 */
	jQuery('.add-ad').click(function() {

		var type = jQuery(this).attr('data-type');
		var button = jQuery(this);
		if( !button.find(':first').hasClass('add-midroll-ad-disabled') ) {

			button.find(':first').addClass('add-midroll-ad-disabled');
			
			$Brid.Api.call(
				{
					data : {action : "adBox", cnt : currentAdCount, type : type}, 
					callback : {after : {name : "addToAdList", obj : button}}
				}
			);

		} else {
			debug.warn('Only one midroll per video!');
		}

		
	});

	/*
	 * Add preroll for outstream unit
	 */
	jQuery('#add-unit-preroll').click(function() {

		var button = jQuery(this);
		if( !button.hasClass('add-midroll-ad-disabled') ) {

			button.addClass('add-midroll-ad-disabled')
			
			$Brid.Api.call({
				data : {action : "adBoxUnit"}, 
				callback : {after : {name : "addToAdListUnit", obj : button}}
			});
			
		} else {
			debug.warn('Only one midroll per unit!');
		}
	});


  function tryToLoadNews(){

    jQuery.ajax({
          url : '<?php echo CLOUDFRONT; ?>WordpressNew/latest/1.json'
      }).done(function(response){

        //console.log('response', response);
        var str = '';
        if(response.length>0){

          for(var i in response){
            if(response[i].WordpressNew!=undefined)
              str += '<li class="bridNewsBoxItem"><a href="'+response[i].WordpressNew.link+'" target="_blank">'+response[i].WordpressNew.name+'</a></li>'
          }
        }

        str += '<li class="bridNewsBoxItem learnMore"><a href="https://brid.zendesk.com/hc/en-us" target="_blank">Learn More >>></a></li>';

        jQuery('#bridWpNews').html(str);
        if(response.length>0)
          jQuery('.bridNewsBox').show();
    }).fail(function(){

      jQuery('#bridWpNews').html('<li class="bridNewsBoxItem">Failed to load.</li>')

    });

  }
  tryToLoadNews();

	/**
	 * Ad management - Delte ad button 
	 */
	function removeAdBox() {

		var iterator = jQuery(this).attr('data-iterator');
		var id = jQuery(this).attr('data-id');
		var adType = jQuery(this).attr('data-type');
    
		if( id != undefined && id != '' ) {
			//Edit mode
			$Brid.Api.call({data : {action : "deleteAd", id : id}, callback : {after : {name : "refreshAdList", obj : jQuery('#brid-box-'+iterator)}}});

		} else {
			//Remove Ad in Add mode (never saved in DB)
			jQuery('#brid-box-'+iterator).parent().fadeOut(300, function() {
				jQuery(this).remove(); 
				//save.toggleSave();
			});

			delete(ads[iterator]);

			//if(adType=='midroll'){ //'midroll'
			debug.log('remove midroll');
			jQuery('#add-'+adType+'-ad').removeClass('add-midroll-ad-disabled');//.addClass('add-midroll-ad');
			//}
		}
  
	}

	function removeUnitAdBox() {

		//console.log("removeUnitAdBox");

		var iterator = jQuery(this).attr('data-iterator');
		var id = jQuery(this).attr('data-id');
		var adType = jQuery(this).attr('data-type');

		if( id != undefined && id != ''  ) {
			$Brid.Api.call({data : {action : "deleteAd", id : id}, callback : {after : {name : "refreshAdListUnit", obj : jQuery('#unit-brid-box-'+iterator)}}});
		} else {

			jQuery('#unit-brid-box-'+iterator).parent().fadeOut(300, function() {
				jQuery(this).remove(); 
			});

			jQuery('#add-unit-preroll').removeClass('add-midroll-ad-disabled');
		}
		
	}
  

    //jQuery(".chzn-select").chosen();

    

	jQuery("#Player").one('click.BridSettings', function() {
		//Do not store config to localstorage
		
		//reloadBridPlayer();
		jQuery(".chzn-select2").chosen();
		//alert('Init Brid_27449775 with:'+playerSelected);
	});

	function reloadBridPlayer(id) {
		debug.log('reloadBridPlayer');
		//if( jQuery('#Player-content').is(':visible') ) {

			Brid.forceConfigLoad = true;
			var videoId = playerSelected;
			if( id != undefined ) {
				videoId = id;
			}
			$bp("Brid_27449775", {"id":videoId,"width":"100%","height":"270","cms":1,"video":"<?php echo DEFAULT_VIDEO_ID; ?>"});
			jQuery('#createCustomSkin').fadeIn();
		//}
	}
	
	function killBridPlayer() {

		jQuery('.bridload[href$=".css"]').remove();//remove all inactive css files (works for Chrome only)

		debug.log('killVeeps() killBridPlayer');
		killVeeps();//@see bridWordpress.js
      
		//Remove all classes bridload with style tag name (FF bug only)
		jQuery('.bridload').each(function(k,v) {
			if(jQuery(this).prop("tagName")=='STYLE') {
				jQuery(this).remove();
			}
		});
		
		try {
			//$bp("Brid_27449775").stop();
			if( $bp("Brid_27449775").isReady ) {
				$bp("Brid_27449775").destroy();
			}
			jQuery("#bridPlayerPreview").append("<div id='Brid_27449775' class='brid'></div>");
		}catch(e){}
	}

	jQuery("#Settings, #Outstream").on('click.BridSettings', function(){

		//killBridPlayer();
	});

	jQuery('#playerSkinSelect').on('change', function(){

		changeSkin();
	});

	function changeSkin(){
		var skin_id = jQuery('#playerSkinSelect :selected').val(); 
		//reloadBridPlayer(playerSelected+'/'+skin_id);
		$bp('Brid_27449775').changeSkin(skin_id);
	}

	function unitChanged() {

		//console.log( "unitChanged()" );

		var selected = jQuery('#unitSelected :selected');
		var unit = selected.data();
		debug.log('BBBBBBB - UNIT OBJECT', unit);


		/* Ads START */
		jQuery('#unitPrerollBox').html('');

		//Unblock add preroll button
		jQuery('#add-unit-preroll').removeClass('add-midroll-ad-disabled');

		unitAds = unit.ad;

		if( unit.ad.length > 0 ) {
			for( var i in unit.ad ) {

				var unitAd = unit.ad[i];
				
				//when some plugins are installed, for i var it can take string "move", that will brake our JS
				if( typeof i != 'function' && i.length <= 2 ) {

					var html = null;
					var iterator = i;

					var template = Handlebars.compile(jQuery('#unit-pre-roll-template').html());
	                
					var showMobileAddWatefall =  unitAd.adTagUrlSec == null || unitAd.adTagUrlSec == "" ? true : false;
					var showMobileAddWaterfallThird = unitAd.adTagUrlThird == null || unitAd.adTagUrlThird == "" ? true : false;
					var showMobileAddWaterfallFourth = unitAd.adTagUrlFourth == null || unitAd.adTagUrlFourth == "" ? true : false;
					
					var showDesktopAddWatefall = unitAd.flashAdTagUrlSec == null || unitAd.flashAdTagUrlSec == "" ? true : false;
					var showDesktopAddWaterfallThird = unitAd.flashAdTagUrlThird == null || unitAd.flashAdTagUrlThird == "" ? true : false;
					var showDesktopAddWaterfallFourth = unitAd.flashAdTagUrlFourth == null || unitAd.flashAdTagUrlFourth == "" ? true : false;

	                    
					var context = {
						id : unitAd.id, 
						iterator: iterator, 
						//redirect_url: "<?php echo OAUTH_PROVIDER."/users/login/?redirect=order"; ?>",
						//paid: paid, 
						//tip : tip , 
						ad_type_int : unitAd.adType, 
						ad_type: adTypes[unitAd.adType], 
						ad_tag_url : unitAd.adTagUrl,
						showMobileAddWatefall: showMobileAddWatefall,
						showMobileAddWaterfallThird: showMobileAddWaterfallThird,
						showMobileAddWaterfallFourth: showMobileAddWaterfallFourth,
						ad_tag_url_sec : unitAd.adTagUrlSec,
						ad_tag_url_third : unitAd.adTagUrlThird,
						ad_tag_url_fourth : unitAd.adTagUrlFourth,
						flash_ad_tag_url : unitAd.flashAdTagUrl,
						showDesktopAddWatefall: showDesktopAddWatefall,
						showDesktopAddWaterfallThird: showDesktopAddWaterfallThird,
						showDesktopAddWaterfallFourth: showDesktopAddWaterfallFourth,
						flash_ad_tag_url_sec : unitAd.flashAdTagUrlSec,
						flash_ad_tag_url_third : unitAd.flashAdTagUrlThird,
						flash_ad_tag_url_fourth : unitAd.flashAdTagUrlFourth,
					};

					html = template(context);

					jQuery('#add-unit-preroll').addClass('add-midroll-ad-disabled');

					if(html){
						jQuery('#unitPrerollBox').append(html);
					}
				}
				
			}
		}

		//Bind remove ad unit
		jQuery(".unit-brid-box-remove").off('click', removeUnitAdBox).on('click', removeUnitAdBox);
        /* Ads END */

		jQuery('#UnitWidth').val( unit.width );
		jQuery('#UnitHeight').val( unit.height );

		//Update unit options
		var chk = jQuery('#checkbox-UnitAutoplayInview').find('input');
		var checkbox = $Brid.Html.CheckboxElement.create({name : 'UnitAutoplayInview'});
		if( unit.autoplayInview ) {
			checkbox.select(chk);
        } else {
			checkbox.deselect(chk);
		}
		checkbox.toggleUnitAutoplayInviewOptions(chk);

		var chk = jQuery('#checkbox-UnitPauseOffView').find('input');
		var checkbox = $Brid.Html.CheckboxElement.create({name : 'UnitPauseOffView'});
		if( unit.pauseOffView ) {
			checkbox.select(chk);
        } else {
			checkbox.deselect(chk);
		}

		var chk = jQuery('#checkbox-UnitViewability').find('input');
		var checkbox = $Brid.Html.CheckboxElement.create({name : 'UnitViewability'});
		if( unit.viewability ) {
			checkbox.select(chk);
        } else {
			checkbox.deselect(chk);
		}

		var chk = jQuery('#checkbox-UnitStartMuted').find('input');
		var checkbox = $Brid.Html.CheckboxElement.create({name : 'UnitStartMuted'});
		if( unit.start_muted ) {
			checkbox.select(chk);
        } else {
			checkbox.deselect(chk);
		}
		checkbox.toggleUnitStartMuted(chk);

		var chk = jQuery('#checkbox-UnitStartMutedRollover').find('input');
		var checkbox = $Brid.Html.CheckboxElement.create({name : 'UnitStartMutedRollover'});
		if( unit.start_muted_rollover ) {
			checkbox.select(chk);
        } else {
			checkbox.deselect(chk);
		}

		var chk = jQuery('#checkbox-UnitInpageMobile').find('input');
		var checkbox = $Brid.Html.CheckboxElement.create({name : 'UnitInpageMobile'});
		if( unit.inpage_mobile ) {
			checkbox.select(chk);
        } else {
			checkbox.deselect(chk);
		}

		var chk = jQuery('#checkbox-UnitSlideInview').find('input');
		var checkbox = $Brid.Html.CheckboxElement.create({name : 'UnitSlideInview'});
		if( unit.slide_inview ) {
			checkbox.select(chk);
        } else {
			checkbox.deselect(chk);
		}

		var chk = jQuery('#checkbox-UnitFlashFallback').find('input');
		var checkbox = $Brid.Html.CheckboxElement.create({name : 'UnitFlashFallback'});
		if( unit.flash_fallback ) {
			checkbox.select(chk);
        } else {
			checkbox.deselect(chk);
		}

		//TAB CLICK MOBILE/DESKTOP TAG
		bindUnitAdTabClick();

		//WATERFALL TAG BIND
		bindUnitWaterfallClick();
	}
	jQuery("#unitSelected").on("change", function() {
		unitChanged();
	})

	function playerChanged() {

    	var paid = <?php  echo ($user->Plan->permissions->waterfall == 1 ? 'true' : 'false'); ?>;
		
		var selected = jQuery('#playerListSelect :selected');
		//var json = selected.attr('data-options');
		var obj = selected.data();
		var player = obj.Player;
		var skin = obj.Skin;
		var ad = obj.Ad;
		debug.log('AAAAAAAAAA - PLAYER OBJECT', obj);

        playerSelected = selected.val();

        jQuery('#PlayerId').val(playerSelected);
        
        //If templatized (created by inteligent skin) show inteligent skin msg
        var templatized = parseInt(skin.templatized ? 1 : 0);
        if(templatized){
            jQuery('#skinList').addClass('disabledInput');
            jQuery('#inteligentSkinMsg').fadeIn();
        }else{
            jQuery('#skinList').removeClass('disabledInput');
            jQuery('#inteligentSkinMsg').hide();
        }
        jQuery('#SkinTemplatized').val(templatized);

        killBridPlayer();
        reloadBridPlayer();

        debug.log('Ads', ad);

        jQuery('#brid-boxes-content').html('');

        //Unblock all ad buttons
        jQuery('.add-ad').each(function(k,v){

          jQuery(v).children().first().removeClass('add-midroll-ad-disabled');

        });

        //Show ad boxes
        if(ad.length>0){

          currentAdCount = ad.length;

          ads = ad;

          //console.log('aaaaa', ad);

          var midrollType = null;
          for(var i in ad){
            
             //console.log('yeah', typeof i);

             //when some plugins are installed, for i var it can take string "move", that will brake our JS
            if(typeof i != 'function' && i.length<=2){

				var html = null;
              
				var iterator = currentAdCount;
              
				if( ad[i].adType == "0" || ad[i].adType == "2") {
					//Pre roll and Post roll
					//var template = Handlebars.compile(jQuery('#pre-roll-template').html());
					var template = Handlebars.compile(jQuery('#ad-box-template').html());
					var tip = 2;
					if( ad[i].adType == 0 ) {
						tip = null;
					}

					var showMobileAddWatefall =  ad[i].adTagUrlSec == null || ad[i].adTagUrlSec == "" ? true : false;
					var showMobileAddWaterfallThird = ad[i].adTagUrlThird == null || ad[i].adTagUrlThird == "" ? true : false;
					var showMobileAddWaterfallFourth = ad[i].adTagUrlFourth == null || ad[i].adTagUrlFourth == "" ? true : false;
					
					var showDesktopAddWatefall = ad[i].flashAdTagUrlSec == null || ad[i].flashAdTagUrlSec == "" ? true : false;
					var showDesktopAddWaterfallThird = ad[i].flashAdTagUrlThird == null || ad[i].flashAdTagUrlThird == "" ? true : false;
					var showDesktopAddWaterfallFourth = ad[i].flashAdTagUrlFourth == null || ad[i].flashAdTagUrlFourth == "" ? true : false;
                    
					var context = {
						id : ad[i].id, 
						iterator: iterator, 
						redirect_url: "<?php echo OAUTH_PROVIDER."/users/login/?redirect=order"; ?>",
						paid: paid, 
						tip : tip , 
						ad_type_int : ad[i].adType, 
						ad_type: adTypes[ad[i].adType], 
						ad_tag_url : ad[i].adTagUrl,
						showMobileAddWatefall: showMobileAddWatefall,
						ad_tag_url_sec : ad[i].adTagUrlSec,
						ad_tag_url_third : ad[i].adTagUrlThird,
						ad_tag_url_fourth : ad[i].adTagUrlFourth,
						showMobileAddWaterfallThird: showMobileAddWaterfallThird,
						showMobileAddWaterfallFourth: showMobileAddWaterfallFourth,
						flash_ad_tag_url : ad[i].flashAdTagUrl,
						showDesktopAddWatefall: showDesktopAddWatefall,
						flash_ad_tag_url_sec : ad[i].flashAdTagUrlSec,
						flash_ad_tag_url_third : ad[i].flashAdTagUrlThird,
						flash_ad_tag_url_fourth : ad[i].flashAdTagUrlFourth,
						showDesktopAddWaterfallThird: showDesktopAddWaterfallThird,
						showDesktopAddWaterfallFourth: showDesktopAddWaterfallFourth,
						isOverlay: ad[i].adType == 3,
						isMidroll: ad[i].adType == 1,
					};
					html    = template(context);
               
				} else if( ad[i].adType == "1" || ad[i].adType == "3") {
	               
	                //Mid Roll & Overlay
	                //var template = Handlebars.compile(jQuery('#'+adTypes[ad[i].adType]+'-template').html());
	                var template = Handlebars.compile(jQuery('#ad-box-template').html());
	                var tip = ad[i].adType;

	                var showMobileAddWatefall =  ad[i].adTagUrlSec == null || ad[i].adTagUrlSec == "" ? true : false;
					var showMobileAddWaterfallThird = ad[i].adTagUrlThird == null || ad[i].adTagUrlThird == "" ? true : false;
					var showMobileAddWaterfallFourth = ad[i].adTagUrlFourth == null || ad[i].adTagUrlFourth == "" ? true : false;
					
					var showDesktopAddWatefall = ad[i].flashAdTagUrlSec == null || ad[i].flashAdTagUrlSec == "" ? true : false;
					var showDesktopAddWaterfallThird = ad[i].flashAdTagUrlThird == null || ad[i].flashAdTagUrlThird == "" ? true : false;
					var showDesktopAddWaterfallFourth = ad[i].flashAdTagUrlFourth == null || ad[i].flashAdTagUrlFourth == "" ? true : false;
	
					var context = {
						id : ad[i].id,
						iterator:  iterator,
						redirect_url: "<?php echo OAUTH_PROVIDER."/users/login/?redirect=order"; ?>",
						paid: paid, 
						tip : tip ,
						ad_type_int : ad[i].adType,
						ad_type: adTypes[ad[i].adType],
						ad_tag_url : ad[i].adTagUrl,
						showMobileAddWatefall: showMobileAddWatefall,
						ad_tag_url_sec : ad[i].adTagUrlSec,
						ad_tag_url_third : ad[i].adTagUrlThird,
						ad_tag_url_fourth : ad[i].adTagUrlFourth,
						showMobileAddWaterfallThird: showMobileAddWaterfallThird,
						showMobileAddWaterfallFourth: showMobileAddWaterfallFourth,
						overlayStartAt : ad[i].overlayStartAt,		//overlay
						overlayDuration : ad[i].overlayDuration,	//overlay
						cuepoints : ad[i].cuepoints, 				//cuepoints
						flash_ad_tag_url : ad[i].flashAdTagUrl,
						showDesktopAddWatefall: showDesktopAddWatefall,
						flash_ad_tag_url_sec : ad[i].flashAdTagUrlSec,
						flash_ad_tag_url_third : ad[i].flashAdTagUrlThird,
						flash_ad_tag_url_fourth : ad[i].flashAdTagUrlFourth,
						showDesktopAddWaterfallThird: showDesktopAddWaterfallThird,
						showDesktopAddWaterfallFourth: showDesktopAddWaterfallFourth,
						isOverlay: ad[i].adType == 3,
						isMidroll: ad[i].adType == 1,
					};
	
					if( ad[i].adType == 1 ) { //Midroll select percentage or seconds
						midrollType = ad[i].adTimeType;
					}
	                
					html    = template(context);
				} else {
					//LOAD 300x250 banner
					var template = Handlebars.compile(jQuery('#ad-box-banner-template').html());

					var context = {
						id : ad[i].id,
						iterator:  iterator,
						ad_type_int : ad[i].adType,
						ad_type: adTypes[ad[i].adType],
						ad_tag_url : ad[i].adTagUrl,
						overlayDuration : ad[i].overlayDuration,
					}

					html    = template(context);
				}
              
				jQuery('#add-'+adTypes[ad[i].adType]+'-ad').addClass('add-midroll-ad-disabled');
	
				if( html ) {
					jQuery('#brid-boxes-content').append(html);
				}
	
				if(midrollType) {
					jQuery("#AdAdTimeType option[value='"+midrollType+"']").prop('selected', true); 
				}
	
				currentAdCount++;
			}

            //Try to select midroll type
		}

		}

        //Init it by default
        jQuery(".brid-box-remove").off('click', removeAdBox).on('click', removeAdBox);
        if(jQuery('.brid-box-midroll').length > 0){
          
          jQuery('#add-midroll-ad').addClass('add-midroll-ad-disabled');
        }

        if(!player.monetize){

          jQuery('#adSettings').css('display', 'none'); //addClass('disabledInput');

        }else{
          jQuery('#adSettings').css('display', 'block'); //removeClass('disabledInput');
        }

        //debug.log('BBBBB', player, 'Skin', skin,  'playerSelected', playerSelected, 'Skin id:', player.skin_id);

        var selectedSkin = jQuery('#playerSkinSelect :selected').val();

        var currentPlayerSkin = player.skin_id;

        //alert(player.id);

        //Select player
        chosenSelect('playerListSelect',playerSelected);

        //Select current skin of the player
        if(currentPlayerSkin!=selectedSkin){

            //Select Skin
            chosenSelect('playerSkinSelect',currentPlayerSkin);

        }

        
       // var selectedD = jQuery('#defaultChannelSelect').val();
        //console.log("selected default", selectedD);

    //    chosenSelect('defaultChannelSelect',selectedD);

        /*jQuery("#playerSkinSelect option[value='"+player.skin_id+"']").attr('selected', 'selected');

        jQuery("#playerSkinSelect").trigger("liszt:updated");*/
        
        //brid_options wp
         jQuery('#width').val(player.width);
         jQuery('#height').val(player.height);
       	 jQuery('#autoplay').val(player.autoplay==1 ? 1 : 0);

         jQuery('#PlayerWidth').val(player.width);
         jQuery('#PlayerHeight').val(player.height);


          //Update flash_fallback player options
 /*       var chk = jQuery('#checkbox-PlayerFlashFallback').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'PlayerFlashFallback'});
        if(player.flash_fallback=='1'){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }*/

         //Update autoplay player options
        var chk = jQuery('#checkbox-PlayerAutoplay').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'PlayerAutoplay'});
        if(player.autoplay){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }
        checkbox.toggleAutoplayOptions(chk);
        
        var chk = jQuery('#checkbox-PlayerAutoplayInview').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'PlayerAutoplayInview'});
        if(player.autoplayInview){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }

        var chk = jQuery('#checkbox-PlayerAutoplayOnAd').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'PlayerAutoplayOnAd'});
        if(player.autoplay_on_ad){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }
        
         //Update autoplay player options
        var chk = jQuery('#checkbox-PlayerStartMuted').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'PlayerStartMuted'});

        if(player.start_muted==1){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }
        //VEEPS
        

        /*var chk = jQuery('#checkbox-voipSocEnabled').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'voipSocEnabled'});
        if(player.voipSocEnabled==1){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }*/
        
        /*var chk = jQuery('#checkbox-veepsChat').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'veepsChat'});
        if(player.veepsChat==1){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }*/

        /*var chk = jQuery('#checkbox-veepsInit').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'veepsInit'});
        if(player.veepsInit==1){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }*/

        var chk = jQuery('#checkbox-inpage_mobile_clicktoplay').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'inpage_mobile_clicktoplay'});
        if(player.inpage_mobile_clicktoplay == 1){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }

        var chk = jQuery('#checkbox-slide_inview').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'slide_inview'});
        if(player.slide_inview==1){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }
        
        /*var chk = jQuery('#checkbox-play_in_page').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'play_in_page'});
        if(player.play_in_page==1){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }

        checkbox.toggleFb(chk);*/
        
        /*var chk = jQuery('#checkbox-veepsType').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'veepsType'});
        if(player.veepsType==1){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }
        
        checkbox.toggleVeepsChatNextToPlayer(chk);*/

        /*var chk = jQuery('#checkbox-voipSocEnabled').find('input');
        var checkbox = $Brid.Html.CheckboxElement.create({name : 'voipSocEnabled'});
        if(player.voipSocEnabled==1){
          checkbox.select(chk);
        }else{
          checkbox.deselect(chk);
        }

        checkbox.toggleVoipSocialOptions(chk);*/
        

		var chk = jQuery('#PlayerAspect');
		var checkbox = $Brid.Html.CheckboxElement.create({name : 'PlayerAspect'});
		checkbox.togglePlayerSize(chk);

        //Call change skin to protect against cached skin
        //changeSkin();

        //TAB CLICK MOBILE/DESKTOP TAG
		bindAdTabClick();

		//WATERFALL TAG BIND
		bindWaterfallClick();

    }
    jQuery("#playerListSelect").on("change", function(){
        playerChanged();
    });
	
    function chosenSelect(id, optionValue){

       jQuery("#"+id+" option[value='"+optionValue+"']").prop('selected', true); //.end().trigger("liszt:updated");
            
            var skinName = jQuery('#'+id+' :selected').text();

            var items = jQuery('#'+id+'_chzn').find('.active-result');

            items.removeClass('result-selected');

            items.each(function(k,v){

              if(jQuery(this).text()==skinName){

                //alert(jQuery(this).text()+'='+skinName)
                jQuery(this).addClass('result-selected');

                jQuery('#'+id+'_chzn').find('.chzn-single').find('span').html(skinName);
                return false;
              }

            });
    }
    //first init
    //playerChanged();

	jQuery("#sites").on("change", function(){
     
		//$Brid.Api.call({action : "brid_api_get_players", "id" : jQuery(this).val(), "callback" : "bridPlayerList"});
		var v = jQuery(this).val();
		jQuery('#PartnerId').val(v)
		/*$Brid.Api.call({
			dataType : 'json',
			data : {action : "getPartnerAndPlayersWithDefaultPlayer", "id" : v}, 
			callback : { after : { name : "bridPlayerList"} }
		});*/

		loadBridPlayers(v);
		loadBridUnits( jQuery('#PartnerId').val() );
	});

	function loadBridPlayers(partnerId){

		$Brid.Api.call({
			dataType : 'json',
			data : {action : "getPartnerAndPlayersWithDefaultPlayer", "id" :  partnerId}, 
			callback : { after : { name : "bridPlayerList"} }
		});

	}

	function loadBridUnits( partnerId ) {

		//console.log("loadBridUnits partnerId", partnerId);

		$Brid.Api.call({
			dataType : 'json',
			data : {action : "getUnitsList", "id" :  partnerId}, 
			callback : { after : { name : "bridUnitList"} }
		});
		
	}
		
	loadBridPlayers(jQuery('#PartnerId').val());
	loadBridUnits(jQuery('#PartnerId').val());

	//Load first time

	jQuery("#IntroVideo").input(function(){
        
		var IntroUrl = jQuery("#IntroVideo").val();
		if( IntroUrl!=undefined && IntroUrl!='' && IntroUrl.length > 0 ) {

			var errDiv = jQuery(this).parent().find('.errorMsg');

			if( !$Brid.Util.isUrl(IntroUrl) ) {
				var errMsg = '*Video Url must be valid URL format.'.toUpperCase();
        
				//$Brid.Util.openDialog('Video Url must be valid URL format.','Invalid input');
				if( errDiv.length == 0 ) {
					jQuery(this).parent().addClass('inputError');
					jQuery(this).parent().append('<div class="errorMsg">'+errMsg+'</div>');
				} else {
					errDiv.html(errMsg);
				}
			} else if( !$Brid.Util.checkExtension(IntroUrl, ["mp4"]) ) {
				//$Brid.Util.openDialog('NOT A VALID VIDEO FORMAT ('+$Brid.Video.allowedVideoExtensions.join(',').toUpperCase()+').', 'Invalid input');
				var errMsg = '*NOT A VALID VIDEO FORMAT ('+["mp4"].join(',').toUpperCase()+' ONLY)';
	        
				if( errDiv.length == 0 ) {
					jQuery(this).parent().addClass('inputError');
					jQuery(this).parent().append('<div class="errorMsg">'+errMsg+'</div>');
				} else {
					errDiv.html(errMsg);
				}
				jQuery(this).val('');
			} else {
				jQuery(this).parent().removeClass('inputError');
				jQuery(this).parent().find('.errorMsg').remove();
			}
		}
	});

	jQuery('.bridBrowseLibary').on('click', function(){
         // If the media frame already exists, reopen it.
          if ( file_frame ) {
            file_frame.open();
            return;
          }

          var field = jQuery('#IntroVideo');

          // Create the media frame.
          file_frame = wp.media.frames.file_frame = wp.media({
            title: jQuery( this ).data( 'uploader_title' ),
            button: {
              text: jQuery( this ).data( 'uploader_button_text' ),
            },
            multiple: false  // Set to true to allow multiple files to be selected
          });

          // When an image is selected, run a callback.
          file_frame.on( 'select', function() {
            // We set multiple to false so only get one image from the uploader
            attachment = file_frame.state().get('selection').first().toJSON();

            if($Brid.Util.checkExtension(attachment.url, $Brid.Util.allowedIntroUrlExtensions)){
                field.val(attachment.url);

                field.parent().find('.errorMsg').remove();
                field.parent().removeClass('inputError');

            }else{
                  alert('Invalid url extension. Video extension required:'+$Brid.Util.allowedIntroUrlExtensions.join(','));
           }
           

          });

          // Finally, open the modal
          file_frame.open();
    });

    jQuery('.bridBrowseLibary').on('click', function(){
        // If the media frame already exists, reopen it.
         if ( file_frame ) {
           file_frame.open();
           return;
         }

         var field = jQuery('#IntroVideo');

         // Create the media frame.
         file_frame = wp.media.frames.file_frame = wp.media({
           title: jQuery( this ).data( 'uploader_title' ),
           button: {
             text: jQuery( this ).data( 'uploader_button_text' ),
           },
           multiple: false  // Set to true to allow multiple files to be selected
         });

         // When an image is selected, run a callback.
         file_frame.on( 'select', function() {
           // We set multiple to false so only get one image from the uploader
           attachment = file_frame.state().get('selection').first().toJSON();

           if($Brid.Util.checkExtension(attachment.url, $Brid.Util.allowedIntroUrlExtensions)){
               field.val(attachment.url);

               field.parent().find('.errorMsg').remove();
               field.parent().removeClass('inputError');

           }else{
                 alert('Invalid url extension. Video extension required:'+$Brid.Util.allowedIntroUrlExtensions.join(','));
          }
          

         });

         // Finally, open the modal
         file_frame.open();
   });
    jQuery('.bridBrowseLibaryImg').on('click', function(){
        // If the media frame already exists, reopen it.
         if ( file_frame ) {
           file_frame.open();
           return;
         }

         var field = jQuery('#VideoImage');

         // Create the media frame.
         file_frame = wp.media.frames.file_frame = wp.media({
           title: jQuery( this ).data( 'uploader_title' ),
           button: {
             text: jQuery( this ).data( 'uploader_button_text' ),
           },
           multiple: false  // Set to true to allow multiple files to be selected
         });

         // When an image is selected, run a callback.
         file_frame.on( 'select', function() {
           // We set multiple to false so only get one image from the uploader
           attachment = file_frame.state().get('selection').first().toJSON();

     //      if($Brid.Util.checkExtension(attachment.url, $Brid.Util.allowedIntroUrlExtensions)){
               field.val(attachment.url);

               field.parent().find('.errorMsg').remove();
               field.parent().removeClass('inputError');

       //    }else{
          //       alert('Invalid url extension. Video extension required:'+$Brid.Util.allowedIntroUrlExtensions.join(','));
         // }
          

         });

         // Finally, open the modal
         file_frame.open();
   });
    //Pre load tab from anchor
    var l = document.location.toString();

    if(l.indexOf('Outstream')!=-1){
      jQuery('#Outstream').trigger('click');
    }
    if(l.indexOf('Player')!=-1){
      jQuery('#Player').trigger('click');
    }

    jQuery('.monetizeTabPage').click(function(e){

      e.preventDefault();
      jQuery('#Player').trigger('click');
    });
	// for defaultChannel and defaultSnapshot
    jQuery("#authPlugin").click(function(){
        
        var def = jQuery("#defaultChannelSelect").val();
        console.log("def",def);
        jQuery("#defaultChannelHidden").val(def);

        var snap = jQuery("#VideoImage").val();
        jQuery("#videoImageHidden").val(snap);
       
    });

	//TAB CLICK MOBILE/DESKTOP TAG FROM OUTSTREAM UNIT
	function bindUnitAdTabClick() {
		jQuery('.unit-ad-tab').on('click', function() {

			if( jQuery(this).hasClass('ad-tab-active') ) {
				return false;
			}

			var tabType = jQuery(this).attr('id').split('-')[1];
			var iterator = jQuery(this).attr('id').split('-')[2];

			var tabItems = jQuery('#unit-tab-container-'+iterator).find('.ad-tab-active');
			tabItems.removeClass('ad-tab-active').addClass('ad-tab-inactive');

			jQuery(this).removeClass('ad-tab-inactive').addClass('ad-tab-active');

			jQuery('.ad-unit-'+tabType+'-tags').show();
			tabType == 'desktop' ? jQuery('.ad-unit-mobile-tags').hide() : jQuery('.ad-unit-desktop-tags').hide();

		});
	}

	function bindUnitWaterfallClick() {

		//Add waterfall
		jQuery('.unit-ad-waterfall').on('click', function() {

			var deviceType = jQuery(this).attr('id').split('-')[2];
			var iterator = jQuery(this).attr('id').split('-')[3];
			var openAd = jQuery(this).data('open');

			//Hide button
			jQuery(this).hide();

			//HIDE PREVIOUS REMOVE TAG BUTTON
			jQuery('#RemoveAdTagSecondary-unit-'+deviceType+'-'+iterator+'-'+(openAd - 1)).hide();

			//Show Secondary
			jQuery('.unit-ad-'+deviceType+'-'+openAd).slideDown();
		});

		//Remove waterfall
		jQuery('.unit-ad-waterfall-remove').on('click', function() {

			var deviceType = jQuery(this).attr('id').split('-')[2];
			var iterator = jQuery(this).attr('id').split('-')[3];
			var closeAd = jQuery(this).data('close');

			//Hide Secondary
			jQuery('.unit-ad-'+deviceType+'-'+closeAd).slideUp(function() {
				//show button
				jQuery('#AdTagSecondary-unit-'+deviceType+'-'+iterator+'-'+closeAd).show();

				//SHOW PREVIOUS REMOVE TAG BUTTON
				jQuery('#RemoveAdTagSecondary-unit-'+deviceType+'-'+iterator+'-'+(closeAd - 1)).show();
			});
			//Empty Tag
			deviceType == 'mobile' ? jQuery('#UnitAdAdTagUrl-'+closeAd).val('') :  jQuery('#UnitAdFlashAdTagUrl-'+closeAd).val('');
		});
	}
	
   
</script>
</div>