<?php
global $wpdb;
$countries = $wpdb->get_results( "SELECT iso2_cnt, name_cnt FROM ec_country ORDER BY name_cnt ASC" );
?>
<div class="ec_admin_list_line_item">
    
	<?php wp_easycart_admin( )->preloader->print_preloader( "ec_admin_shipping_dhl_display_loader" ); ?>
    
    <div class="ec_admin_settings_label"><div class="dashicons-before dashicons-screenoptions"></div><span>DHL Setup</span><a href="<?php echo wp_easycart_admin( )->helpsystem->print_docs_url('settings', 'shipping-settings', 'dhl');?>" target="_blank" class="ec_help_icon_link"><div class="dashicons-before ec_help_icon dashicons-info"></div></a>
    <?php echo wp_easycart_admin( )->helpsystem->print_vids_url('settings', 'shipping-settings', 'dhl');?></div>
    
    <div class="ec_admin_settings_input ec_admin_settings_live_payment_section">
    
    	<div>DHL Site ID <input type="text" name="dhl_site_id" id="dhl_site_id" value="<?php echo wp_easycart_admin( )->settings->dhl_site_id; ?>" /></div>
        <div>Password <input type="text" name="dhl_password" id="dhl_password" value="<?php echo wp_easycart_admin( )->settings->dhl_password; ?>" /></div>
        <div>Ship From Postal Code <input type="text" name="dhl_ship_from_zip" id="dhl_ship_from_zip" value="<?php echo wp_easycart_admin( )->settings->dhl_ship_from_zip; ?>" /></div>
        <div>Country Code <select name="dhl_ship_from_country" id="dhl_ship_from_country">
        	<option value="US"<?php if( wp_easycart_admin( )->settings->dhl_ship_from_country == 'US' ){ ?> selected="selected"<?php }?>>United States</option>
            <?php foreach( $countries as $country ){ ?>
			<option value="<?php echo $country->iso2_cnt; ?>"<?php if( $country->iso2_cnt == wp_easycart_admin( )->settings->dhl_ship_from_country ){ ?> selected="selected"<?php }?>><?php echo $country->name_cnt; ?></option>
			<?php } ?>
        </select></div>
        <div>Weight Type <select name="dhl_weight_unit" id="dhl_weight_unit">
        	<option value="LB"<?php if( wp_easycart_admin( )->settings->dhl_weight_unit == 'LB' ){ ?> selected="selected"<?php }?>>LB</option>
            <option value="KG"<?php if( wp_easycart_admin( )->settings->dhl_weight_unit == 'KG' ){ ?> selected="selected"<?php }?>>KG</option>
        </select></div>
        <div>DHL Account Number <input type="text" name="dhl_account_number" id="dhl_account_number" value="<?php echo get_option( 'ec_option_dhl_account_number' ); ?>" /></div>
        <div><input type="checkbox" name="dhl_test_mode" id="dhl_test_mode" value="1"<?php if( wp_easycart_admin( )->settings->dhl_test_mode ){ ?> checked="checked"<?php }?>/>Test Mode</div>
        
    </div>
    
    <div class="ec_admin_settings_input">
        <input type="submit" class="ec_admin_settings_simple_button" onclick="return ec_admin_save_dhl_shipping_options( );" value="Save Options" />
    	<?php $dhl_status = wp_easycart_admin_live_shipping_rates_pro( )->get_dhl_status( ); ?>
        <div class="ec_admin_live_shipping_status_<?php echo $dhl_status; ?>" id="ec_admin_dhl_status">
        	<?php if( $dhl_status == 'connected' ){ echo 'Connected'; }else if( $dhl_status == 'error' ){ echo 'Error'; }else{ echo 'Disabled'; } ?>
        </div>
    </div>
    
</div>