<?php
$table = new wp_easycart_admin_table( );
$table->set_table( 'ec_promocode', 'promocode_id' );
$table->set_table_id( 'ec_admin_coupon_list' );
$table->set_default_sort( 'promocode_id', 'ASC' );
$table->set_header( 'Manage Coupons' );
$table->set_icon( 'feedback' );
$table->set_docs_link ('marketing','coupons');
$table->set_list_columns( 
	array(
		array( 
			'name' 	=> 'promocode_id', 
			'label'	=> 'Coupon Code',
			'format'=> 'string'
		),
		array( 
			'name' 	=> 'is_dollar_based',
			'label'	=> 'Dollar',
			'format'=> 'checkbox'
		),
		array( 
			'name' 	=> 'is_percentage_based',
			'label'	=> 'Percentage',
			'format'=> 'checkbox'
		),
		array( 
			'name' 	=> 'is_shipping_based',
			'label'	=> 'Shipping',
			'format'=> 'checkbox'
		),
		array( 
			'name' 	=> 'is_free_item_based',
			'label'	=> 'Free Item',
			'format'=> 'checkbox'
		)
	)
);
$table->set_search_columns(
	array( 'ec_promocode.promocode_id' )
);
$table->set_bulk_actions(
	array(
		array(
			'name'	=> 'delete-coupon',
			'label'	=> 'Delete'
		)
	)
);
$table->set_actions(
	array(
		array(
			'name'	=> 'edit',
			'label'	=> 'Edit',
			'icon'	=> 'edit'
		),
		array(
			'name'	=> 'delete-coupon',
			'label'	=> 'Delete',
			'icon'	=> 'trash'
		)
	)
);

$table->set_filters(
	array( )
);
$table->set_label( 'Coupon Code', 'Coupon Codes' );
$table->print_table( );
?>