<?php
$table = new wp_easycart_admin_table( );
$table->set_table( 'ec_promotion', 'promotion_id' );
$table->set_default_sort( 'start_date', 'DESC' );
$table->set_header( 'Manage Promotions' );
$table->set_icon( 'tag' );
$table->set_docs_link ('marketing','promotions');
$table->set_list_columns( 
	array(
		array( 
			'name' 	=> 'name',
			'label'	=> 'Promotion Name',
			'format'=> 'text'
		),
		array( 
			'name' 	=> 'start_date',
			'label'	=> 'Start Date',
			'format'=> 'date'
		),
		array( 
			'name' 	=> 'end_date',
			'label'	=> 'End Date',
			'format'=> 'date'
		)
	)
);
$table->set_search_columns(
	array( 'ec_promotion.name' )
);
$table->set_bulk_actions(
	array(
		array(
			'name'	=> 'delete-promotion',
			'label'	=> 'Delete'
		)
	)
);
$table->set_actions(
	array(
		array(
			'name'	=> 'edit',
			'label'	=> 'Edit',
			'icon'	=> 'edit'
		),
		array(
			'name'	=> 'delete-promotion',
			'label'	=> 'Delete',
			'icon'	=> 'trash'
		)
	)
);

$table->set_filters(
	array( )
);
$table->set_label( 'Promotion', 'Promotions' );
$table->print_table( );
?>