<?php
class wp_easycart_admin_products_pro{
	
	public function __construct( ){ 
		if( wp_easycart_admin_license( )->is_licensed( ) ){
			/* Advanced Options */
			add_filter( 'wp_easycart_admin_product_details_options_fields_list', array( $this, 'add_advanced_options' ) );
			
			/* Option Item Images */
			add_filter( 'wp_easycart_admin_product_details_images_fields_list', array( $this, 'add_optionset_images' ) );
			
			/* Option Item Quantity Tracking */
			add_filter( 'wp_easycart_admin_optionitem_quantity_add_click', array( $this, 'allow_add_optionitem_quantity_tracking' ) );
			add_filter( 'wp_easycart_admin_optionitem_quantity_update_click', array( $this, 'allow_update_optionitem_quantity_tracking' ) );
			add_filter( 'wp_easycart_admin_optionitem_quantity_delete_click', array( $this, 'allow_delete_optionitem_quantity_tracking' ) );
			
			/* Volume Pricing */
			add_filter( 'wp_easycart_admin_tiered_pricing_add_click', array( $this, 'allow_add_tiered_pricing' ) );
			add_filter( 'wp_easycart_admin_tiered_pricing_edit_click', array( $this, 'allow_edit_tiered_pricing' ) );
			add_filter( 'wp_easycart_admin_tiered_pricing_delete_click', array( $this, 'allow_delete_tiered_pricing' ) );
			
			/* B2B Pricing */
			add_filter( 'wp_easycart_admin_b2b_pricing_add_click', array( $this, 'allow_add_b2b_pricing' ) );
			add_filter( 'wp_easycart_admin_b2b_pricing_delete_click', array( $this, 'allow_delete_b2b_pricing' ) );
			
			/* General Options (Pro Only) */
			add_filter( 'wp_easycart_admin_product_details_general_options_fields_list', array( $this, 'add_general_options' ) );
			
			/* Tax Options (Pro Only) */
			add_filter( 'wp_easycart_admin_product_details_tax_fields_list', array( $this, 'add_tax_options' ) );
			
			/* Deconetwork */
			add_filter( 'wp_easycart_admin_product_details_deconetwork_fields_list', array( $this, 'add_deconetwork' ) );
			
			/* Subscription */
			add_filter( 'wp_easycart_admin_product_details_subscription_fields_list', array( $this, 'add_subscription' ) );
			
			/* Downloads */
			add_filter( 'wp_easycart_admin_product_details_downloads_fields_list', array( $this, 'add_downloads' ) );
		}
	}

	/* Advanced Options */
	public function add_advanced_options( $fields ){
		for( $i=0; $i<count( $fields ); $i++ ){
			if( $fields[$i]['name'] == 'use_advanced_optionset' ){
				$fields[$i]['onclick'] = 'advanced_options_change';
				$fields[$i]['read-only'] = false;
				break;
			}
		}
		$fields[] = array(
			"name"				=> "advanced_options",
			"type"				=> "advanced_options"
		);
		return $fields;
	}
	
	/* Option Item Images */
	public function add_optionset_images( $fields ){
		for( $i=0; $i<count( $fields ); $i++ ){
			if( $fields[$i]['name'] == 'use_optionitem_images' ){
				$fields[$i]['onclick'] = 'optionitem_images_change';
				$fields[$i]['read-only'] = false;
				break;
			}
		}
		$fields[] = array(
			"name"				=> "optionitem_images",
			"type"				=> "optionitem_images"
		);
		return $fields;
	}
	
	/* Option Item Quantity Tracking */
	public function allow_add_optionitem_quantity_tracking( $action ){
		return "ec_admin_product_details_add_optionitem_quantity";
	}
	
	public function allow_update_optionitem_quantity_tracking( $action ){
		return "ec_admin_product_details_update_optionitem_quantity";
	}
	
	public function allow_delete_optionitem_quantity_tracking( $action ){
		return "ec_admin_product_details_delete_optionitem_quantity";
	}
	
	/* Tiered Pricing */
	public function allow_add_tiered_pricing( $action ){
		return "ec_admin_product_details_add_price_tier";
	}
	
	public function allow_edit_tiered_pricing( $action ){
		return "ec_admin_product_details_edit_price_tier";
	}
	
	public function allow_delete_tiered_pricing( $action ){
		return "ec_admin_product_details_delete_price_tier";
	}
	
	/* B2B Pricing */
	public function allow_add_b2b_pricing( $action ){
		return "ec_admin_product_details_add_role_price";
	}
	
	public function allow_delete_b2b_pricing( $action ){
		return "ec_admin_product_details_delete_role_price";
	}
	
	/* General Options */
	public function add_general_options( $fields ){
		for( $i=0; $i<count( $fields ); $i++ ){
			if( $fields[$i]['name'] == 'is_donation' ){
				unset( $fields[$i]['onclick'] );
				$fields[$i]['read-only'] = false;
			
			}else if( $fields[$i]['name'] == 'is_giftcard' ){
				unset( $fields[$i]['onclick'] );
				$fields[$i]['read-only'] = false;
			
			}else if( $fields[$i]['name'] == 'inquiry_mode' ){
				$fields[$i]['onclick'] = 'ec_admin_product_details_inquiry_change';
				$fields[$i]['read-only'] = false;
			
			}else if( $fields[$i]['name'] == 'catalog_mode' ){
				unset( $fields[$i]['onclick'] );
				$fields[$i]['read-only'] = false;
			}
		}
		return $fields;
	}
	
	/* Tax Options */
	public function add_tax_options( $fields ){
		for( $i=0; $i<count( $fields ); $i++ ){
			if( $fields[$i]['name'] == 'TIC' ){
				unset( $fields[$i]['onclick'] );
				$fields[$i]['read-only'] = false;
			}
		}
		return $fields;
	}
	
	/* Deconetwork */
	public function add_deconetwork( $fields ){
		for( $i=0; $i<count( $fields ); $i++ ){
			if( $fields[$i]['name'] == 'is_deconetwork' ){
				$fields[$i]['onclick'] = 'ec_admin_product_details_deconetwork_toggle';
				$fields[$i]['read-only'] = false;
				break;
			}
		}
		return $fields;
	}
	
	/* Subscription */
	public function add_subscription( $fields ){
		for( $i=0; $i<count( $fields ); $i++ ){
			if( $fields[$i]['name'] == 'is_subscription_item' ){
				$fields[$i]['onclick'] = 'ec_admin_product_details_subscription_change';
				$fields[$i]['read-only'] = false;
				break;
			}
		}
		return $fields;
	}
	
	/* Downloads */
	public function add_downloads( $fields ){
		for( $i=0; $i<count( $fields ); $i++ ){
			if( $fields[$i]['name'] == 'is_download' ){
				$fields[$i]['onclick'] = 'ec_admin_product_details_download_toggle';
				$fields[$i]['read-only'] = false;
				break;
			}
		}
		return $fields;
	}
}
new wp_easycart_admin_products_pro( );