<?php
$table = new wp_easycart_admin_table( );
$table->set_table( 'ec_giftcard', 'giftcard_id' );
$table->set_default_sort( 'giftcard_id', 'ASC' );
$table->set_header( 'Manage Gift Cards' );
$table->set_icon( 'products' );
$table->set_docs_link ('marketing','gift-cards');
$table->set_list_columns( 
	array(
		array( 
			'name' 	=> 'giftcard_id', 
			'label'	=> 'Gift Card ID',
			'format'=> 'string'
		),
		array( 
			'name' 	=> 'amount',
			'label'	=> 'Amount Remaining',
			'format'=> 'currency'
		)
	)
);
$table->set_search_columns(
	array( 'ec_giftcard.giftcard_id' )
);
$table->set_bulk_actions(
	array(
		array(
			'name'	=> 'delete-giftcard',
			'label'	=> 'Delete'
		)
	)
);
$table->set_actions(
	array(
		array(
			'name'	=> 'edit',
			'label'	=> 'Edit',
			'icon'	=> 'edit'
		),
		array(
			'name'	=> 'delete-giftcard',
			'label'	=> 'Delete',
			'icon'	=> 'trash'
		)
	)
);

$table->set_filters(
	array( )
);
$table->set_label( 'Gift Card', 'Gift Cards' );
$table->print_table( );
?>