<?php
if( !defined( 'ABSPATH' ) ) exit;

class wp_easycart_admin_details_promotions extends wp_easycart_admin_details{
	
	public $promotion;
	
	public function __construct( ){
		parent::__construct( );
		add_action( 'wp_easycart_admin_promotion_details_stepone_fields', array( $this, 'stepone_fields' ) );
		add_action( 'wp_easycart_admin_promotion_details_steptwo_fields', array( $this, 'steptwo_fields' ) );
		add_action( 'wp_easycart_admin_promotion_details_stepthree_fields', array( $this, 'stepthree_fields' ) );
		add_action( 'wp_easycart_admin_promotion_details_stepfour_fields', array( $this, 'stepfour_fields' ) );
	}
	
	protected function init( ){
		$this->id = 0;
		$this->page = 'wp-easycart-rates';
		$this->subpage = 'promotions';
		$this->action = 'admin.php?page=' . $this->page . '&subpage=' . $this->subpage;
		$this->form_action = 'add-new-promotion';
		$this->promotion = (object) array(
			"promotion_id"					=> "",
			"name"							=> "",
			"type"							=> "",
			"start_date"					=> "",
			"end_date"						=> "",
			"product_id_1"					=> "",
			"product_id_2"					=> "",
			"product_id_3"					=> "",
			"manufacturer_id_1"				=> "",
			"manufacturer_id_2"				=> "",
			"manufacturer_id_3"				=> "",
			"category_id_1"					=> "",
			"category_id_2"					=> "",
			"category_id_3"					=> "",
			"price1"						=> "",
			"price2"						=> "",
			"price3"						=> "",
			"percentage1"					=> "",
			"percentage2"					=> "",
			"percentage3"					=> "",
			"number1"						=> "",
			"number2"						=> "",	
			"number3"						=> ""	
		);
	}
	
	protected function init_data( ){
		$this->form_action = 'update-promotion';
		$this->docs_link = 'http://docs.wpeasycart.com/wp-easycart-administrative-console-guide/?section=promotions';
		$this->promotion = $this->wpdb->get_row( $this->wpdb->prepare( "SELECT ec_promotion.* FROM ec_promotion WHERE promotion_id = %s", $_GET['promotion_id'] ) );
		$this->id = $this->promotion->promotion_id;
	}

	public function output( $type = 'edit' ){
		$this->init( );
		if( $type == 'edit' )
			$this->init_data( );
		include( WP_EASYCART_ADMIN_PRO_PLUGIN_DIR . 'admin/template/marketing/promotions/promotion-details.php');
	}
	
	public function stepone_fields( ){
		$fields = apply_filters( 'wp_easycart_admin_coupon_details_stepone_fields_list', array(
			
			array(
				"panel"	=> "basic",
				"name"	=> "promotion_id",
				"alt_name"	=> "promotion_id",
				"type"	=> "hidden",
				"value" => $this->promotion->promotion_id
			),
			array(
				"panel"	=> "basic",
				"name"	=> "name",
				"type"	=> "text",
				"label"	=> "Promotion Name",
				"required" => true,
				"message" => "Please enter a unique name for this promotion.",
				"validation_type" => 'text',
				"value" => $this->promotion->name
			),
			array(
				"panel"	=> "basic",
				"name"	=> "start_date",
				"type"	=> "date",
				"label"	=> "Promotion Start Date",
				"required" => true,
				"message" => "Please enter a date this promotion will begin.",
				"validation_type" => 'date',
				"value" => $this->promotion->start_date
			),
			array(
				"panel"	=> "basic",
				"name"	=> "end_date",
				"type"	=> "date",
				"label"	=> "Promotion End Date",
				"required" => true,
				"message" => "Please enter a date this promotion will end.",
				"validation_type" => 'date',
				"value" => $this->promotion->end_date
			)
			
		) );
		$this->print_fields( $fields );
	}
	
	public function steptwo_fields( ){
		$promotion_type = array( 
			(object) array( 
				"id" => 1, 
				"value" => "Price/Percentage off a product or group of products" 
			),
			(object) array( 
				"id" => 6, 
				"value" => "Price/Percentage off when certain dollar value reached" 
			),
			(object) array( 
				"id" => 4, 
				"value" => "Shipping discount when certain dollar value reached" 
			)
			
		);
		
		$fields = apply_filters( 'wp_easycart_admin_coupon_details_steptwo_fields_list', array(
		
			array(
				"panel" => "basic",
				"name"	=> "type",
				"type"	=> "select",
				"data"	=> $promotion_type,
				"data_label" => "Choose a Promotion Type",
				"label" => "Promotion Type",
				"required" => true,
				"message" => "Please select a promotion type",
				"validation_type" => 'select',
				"onchange" => "ec_admin_promotion_type_change",
				"value" => $this->promotion->type
				
		
			)
			
		) );
		$this->print_fields( $fields );
	}
	
	
	public function stepthree_fields( ){
		global $wpdb;
		$all_products = $wpdb->get_results( "SELECT ec_product.product_id AS id, ec_product.title AS value FROM ec_product ORDER BY title ASC" );
		$manufacturers = $wpdb->get_results( "SELECT ec_manufacturer.manufacturer_id AS id, ec_manufacturer.name AS value FROM ec_manufacturer ORDER BY name ASC" );
		$categories = $wpdb->get_results( "SELECT ec_category.category_id AS id, ec_category.category_name AS value FROM ec_category ORDER BY category_name ASC" );

		$fields = apply_filters( 'wp_easycart_admin_coupon_details_stepthree_fields_list', array(
		
			array(
				"panel"	=> "basic",
				"name"	=> "price2",
				"type"	=> "currency",
				"label"	=> "Price Threshold",
				"required" => false,
				"message" => "Please enter a price that will trigger this promotion.",
				"validation_type" => 'number',
				"requires"=>array(
					"name"=>"type",
					"value"=>"1",
					"default_show"=> false
				),
				"value" => $this->promotion->price2
		
			),
			array(
				"panel" => "basic",
				"name"	=> "product_id_1",
				"type"	=> "select",
				"data"	=> $all_products,
				"data_label" => "No Product Selected",
				"label" => "Select Product",
				"required" => false,
				"message" => "Please select a product",
				"requires"=>array(
					"name"=>"type",
					"value"=>"1",
					"default_show"=> false
				),
				"onchange" => "ec_admin_promotion_reset_selections",
				"value" => $this->promotion->product_id_1
				
			),
			array(
				"panel" => "basic",
				"name"	=> "manufacturer_id_1",
				"type"	=> "select",
				"data"	=> $manufacturers,
				"data_label" => "No Manufacturer Selected",
				"label" => "Select Manufacturer",
				"required" => false,
				"message" => "Please select a manufacturer",
				"requires"=>array(
					"name"=>"type",
					"value"=>"1",
					"default_show"=> false
				),
				"onchange" => "ec_admin_promotion_reset_selections",
				"value" => $this->promotion->manufacturer_id_1
			),
			array(
				"panel" => "basic",
				"name"	=> "category_id_1",
				"type"	=> "select",
				"data"	=> $categories,
				"data_label" => "No Category Selected",
				"label" => "Select Category",
				"required" => false,
				"message" => "Please select a category",
				"requires"=>array(
					"name"=>"type",
					"value"=>"1",
					"default_show"=> false
				),
				"onchange" => "ec_admin_promotion_reset_selections",
				"value" => $this->promotion->category_id_1
			)
			
		) );
		$this->print_fields( $fields );
	}
	
	public function stepfour_fields( ){

		$fields = apply_filters( 'wp_easycart_admin_coupon_details_stepfour_fields_list', array(
		
			array(
				"panel"	=> "basic",
				"name"	=> "price1",
				"type"	=> "currency",
				"label"	=> "Price Discount",
				"required" => false,
				"message" => "Please enter how much customers will receive off.",
				"validation_type" => 'number',
				"onchange" => "ec_admin_promotion_reset_discount",
				"value" => $this->promotion->price1
		
			),
			array(
				"panel"	=> "basic",
				"name"	=> "percentage1",
				"type"	=> "text",
				"label"	=> "Percentage Discount",
				"required" => false,
				"message" => "Please enter how much customers will receive off.",
				"validation_type" => 'number',
				"onchange" => "ec_admin_promotion_reset_discount",
				"value" => $this->promotion->percentage1
		
			)
			
		) );
		$this->print_fields( $fields );
	}
	
	
}