<?php
$table = new wp_easycart_admin_table( );
$table->set_table( 'ec_subscription', 'subscription_id' );
$table->set_table_id( 'ec_admin_subscription_list' );
$table->set_default_sort( 'next_payment_date', 'DESC' );
$table->set_docs_link ('orders','subscriptions');
$table->set_icon( 'update' );
$table->set_add_new(false, '', '');
$table->set_list_columns( 
	array(
		array( 
			'name' 	=> 'title', 
			'label'	=> 'Subscription Title',
			'format'=> 'string'
		),
		array( 
			'name' 	=> 'subscription_status',
			'label'	=> 'Status',
			'format'=> 'string'
		),
		array( 
			'name' 	=> 'first_name',
			'label'	=> 'First Name',
			'format'=> 'string'
		),
		array( 
			'name' 	=> 'last_name',
			'label'	=> 'Last Name',
			'format'=> 'string'
		),
		array( 
			'name' 	=> 'price',
			'label'	=> 'Price',
			'format'=> 'currency'
		)
	)
);
$table->set_search_columns(
	array( 'ec_subscription.title', 'ec_subscription.email', 'ec_subscription.first_name', 'ec_subscription.last_name', 'ec_subscription.subscription_status' )
);
$table->set_bulk_actions(
	array(
		array(
			'name'	=> 'delete-subscription',
			'label'	=> 'Delete'
		)
	)
);
$table->set_actions(
	array(
		array(
			'name'	=> 'edit',
			'label'	=> 'Edit',
			'icon'  => 'edit'
		),
		array(
			'name'	=> 'delete-subscription',
			'label'	=> 'Delete',
			'icon'  => 'trash'
		)
	)
);
$table->set_filters(
	array( )
);
$table->set_label( 'Subscription', 'Subscriptions' );
$table->print_table( );
?>