<?php
if( !defined( 'ABSPATH' ) ) exit;

if( !class_exists( 'wp_easycart_admin_taxes_pro' ) ) :

final class wp_easycart_admin_taxes_pro{
	
	protected static $_instance = null;
	
	public $tax_cloud_file;
	
	public static function instance( ) {
		
		if( is_null( self::$_instance ) ) {
			self::$_instance = new self(  );
		}
		return self::$_instance;
	
	}
		
	public function __construct( ){
		$this->tax_cloud_setup_file 		= WP_EASYCART_ADMIN_PRO_PLUGIN_DIR . 'admin/template/settings/taxes/tax-cloud-setup.php';
		
		if( wp_easycart_admin_license( )->is_licensed( ) ){
			// Actions
			remove_action( 'wpeasycart_admin_tax_setup', array( wp_easycart_admin_taxes( ), 'load_tax_cloud_setup' ) );
			add_action( 'wpeasycart_admin_tax_setup', array( $this, 'load_tax_cloud_setup' ) );
			add_action( 'init', array( $this, 'save_settings' ) );
		}
	}
	
	public function load_tax_cloud_setup( ){
		include( $this->tax_cloud_setup_file );
	}
	
	/* Tax Cloud */
	public function save_tax_cloud( ){
		update_option( 'ec_option_tax_cloud_api_id', stripslashes_deep( $_POST['ec_option_tax_cloud_api_id'] ) );
		update_option( 'ec_option_tax_cloud_api_key', stripslashes_deep( $_POST['ec_option_tax_cloud_api_key'] ) );
		update_option( 'ec_option_tax_cloud_address', stripslashes_deep( $_POST['ec_option_tax_cloud_address'] ) );
		update_option( 'ec_option_tax_cloud_city', stripslashes_deep( $_POST['ec_option_tax_cloud_city'] ) );
		update_option( 'ec_option_tax_cloud_state', stripslashes_deep( $_POST['ec_option_tax_cloud_state'] ) );
		update_option( 'ec_option_tax_cloud_zip', stripslashes_deep( $_POST['ec_option_tax_cloud_zip'] ) );
	}
	
}
endif; // End if class_exists check

function wp_easycart_admin_taxes_pro( ){
	return wp_easycart_admin_taxes_pro::instance( );
}
wp_easycart_admin_taxes_pro( );

/* Tax Rate Hooks - Tax Cloud */
add_action( 'wp_ajax_ec_admin_ajax_update_tax_cloud', 'ec_admin_ajax_update_tax_cloud' );
function ec_admin_ajax_update_tax_cloud( ){
	wp_easycart_admin_taxes_pro( )->save_tax_cloud( );
	die( );

}