<?php
if( !defined( 'ABSPATH' ) ) exit;

class wp_easycart_admin_details_subscriptions extends wp_easycart_admin_details{
	
	public $subscription;

	
	public function __construct( ){
		parent::__construct( );
		add_action( 'wp_easycart_admin_subscription_details_basic_fields', array( $this, 'basic_fields' ) );
		add_action( 'wp_easycart_admin_subscription_details_subscription_terms_fields', array( $this, 'subscription_terms_fields' ) );
		add_action( 'wp_easycart_admin_subscription_details_product_info_fields', array( $this, 'product_info_fields' ) );
		add_action( 'wp_easycart_admin_subscription_details_customer_info_fields', array( $this, 'customer_info_fields' ) );

		add_action( 'wp_easycart_admin_subscription_details_stripe_info_fields', array( $this, 'stripe_info_fields' ) );
		add_action( 'wp_easycart_admin_subscription_details_paypal_info_fields', array( $this, 'paypal_info_fields' ) );
	}
	
	protected function init( ){
		$this->docs_link = 'http://docs.wpeasycart.com/wp-easycart-administrative-console-guide/?section=subscriptions';
		$this->id = 0;
		$this->page = 'wp-easycart-orders';
		$this->subpage = 'subscriptions';
		$this->action = 'admin.php?page=' . $this->page . '&subpage=' . $this->subpage;
		$this->form_action = 'add-new-subscription';
		$this->user_role = (object) array(
			"subscription_id"					=> "",
			"subscription_type"					=> "",
			"subscription_status"				=> "",
			"number_payments_completed"			=> "",
			"num_failed_payment"				=> "",
			
			"payment_length"					=> "",
			"payment_period"					=> "",
			"start_date"						=> "",
			"last_payment_date" 				=> "",
			"next_payment_date"					=> "",
			
			"title"								=> "",
			"product_id"						=> "",
			"model_number"						=> "",
			"price"								=> "",
			
			"user_id"							=> "",
			"email"								=> "",
			"first_name"						=> "",
			"last_name"							=> "",
			"user_country"						=> "",

			"paypal_txn_id"						=> "",
			"paypal_txn_type"					=> "",
			"paypal_subscr_id"					=> "",
			"paypal_username"					=> "",
			"paypal_password"					=> "",
			
			"stripe_subscription_id"			=> "",
			"payment_duration"					=> "",
			"quantity"							=> "",
			
		);

	}
	
	protected function init_data( ){
		$this->form_action = 'update-subscription';
		$this->subscription = $this->wpdb->get_row( $this->wpdb->prepare( "SELECT ec_subscription.*, ec_user.stripe_customer_id FROM ec_subscription LEFT JOIN ec_user ON ec_user.user_id = ec_subscription.user_id WHERE subscription_id = %d", $_GET['subscription_id'] ) );
		$this->id = $this->subscription->subscription_id;

		
	}

	public function output( $type = 'edit' ){
		$this->init( );
		if( $type == 'edit' )
			$this->init_data( );
		
		include( WP_EASYCART_ADMIN_PRO_PLUGIN_DIR. 'admin/template/orders/subscriptions/subscriptions-details.php' );
	}
	
	public function basic_fields( ){

		$fields = apply_filters( 'wp_easycart_admin_subscriptions_details_basic_fields_list', array(
			array(
				"name"				=> "subscription_id",
				"type"				=> "text",
				"label"				=> "Unique subscription ID",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->subscription_id
			),
			array(
				"name"				=> "subscription_type",
				"type"				=> "text",
				"label"				=> "Subscription Type",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->subscription_type
			),
			array(
				"name"				=> "subscription_status",
				"type"				=> "text",
				"label"				=> "Subscription Status",
				"required" 			=> true,
				"read-only"			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"value"				=> $this->subscription->subscription_status
			),
			array(
				"name"				=> "number_payments_completed",
				"type"				=> "text",
				"label"				=> "Payments Completed",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->number_payments_completed
			),
			array(
				"name"				=> "num_failed_payment",
				"type"				=> "text",
				"label"				=> "Failed Payments",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->num_failed_payment
			)

		) );
		$this->print_fields( $fields );
	}
	
	public function isValidTimeStamp($timestamp)
		{
			return ((string) (int) $timestamp === $timestamp) 
				&& ($timestamp <= PHP_INT_MAX)
				&& ($timestamp >= ~PHP_INT_MAX);
		}
		
	public function subscription_terms_fields( ){
		$period = '';
		if ($this->subscription->payment_period == 'W') $period = 'Weekly';
		else if ($this->subscription->payment_period == 'M') $period = 'Monthly';
		else if ($this->subscription->payment_period == 'Y') $period = 'Yearly';
		else if ($this->subscription->payment_period == 'D') $period = 'Daily';
		else if ($this->subscription->payment_period == 'H') $period = 'Hourly';
		
		$fields = apply_filters( 'wp_easycart_admin_subscription_terms_fields_list', array(
			array(
				"name"				=> "payment_length",
				"type"				=> "text",
				"label"				=> "Payment Interval",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->payment_length
			),
			array(
				"name"				=> "payment_period",
				"type"				=> "text",
				"label"				=> "Payment Period",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $period
			),
			array(
				"name"				=> "start_date",
				"type"				=> "date",
				"label"				=> "Start Date",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'date',
				"read-only"			=> true,
				"value"				=> $this->subscription->start_date
			),
			array(
				"name"				=> "last_payment_date",
				"type"				=> "date",
				"label"				=> "Last Payment",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'date',
				"read-only"			=> true,
				"value"				=> $this->subscription->last_payment_date
			),
			array(
				"name"				=> "next_payment_date",
				"type"				=> "date",
				"label"				=> "Next Payment",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'date',
				"read-only"			=> true,
				"value"				=> $this->subscription->next_payment_date
			)

		) );
		$this->print_fields( $fields );
	}
	
	public function product_info_fields( ){

		$fields = apply_filters( 'wp_easycart_admin_product_info_fields_list', array(
			array(
				"name"				=> "title",
				"type"				=> "text",
				"label"				=> "Product Title",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->title
			),
			array(
				"name"				=> "product_id",
				"type"				=> "text",
				"label"				=> "Product ID",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->product_id
			),
/*			array(
				"name"				=> "model_number",
				"type"				=> "text",
				"label"				=> "Model Number",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->model_number
			),*/
			array(
				"name"				=> "price",
				"type"				=> "currency",
				"label"				=> "Purchase Price",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'currency',
				"read-only"			=> true,
				"value"				=> $this->subscription->price
			)

		) );
		$this->print_fields( $fields );
	}
	
	public function customer_info_fields( ){

		$fields = apply_filters( 'wp_easycart_admin_customer_info_fields_list', array(
			array(
				"name"				=> "user_id",
				"type"				=> "text",
				"label"				=> "User ID",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->user_id
			),
			array(
				"name"				=> "email",
				"type"				=> "text",
				"label"				=> "Email Address",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->email
			),
			array(
				"name"				=> "first_name",
				"type"				=> "text",
				"label"				=> "First Name",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->first_name
			),
			array(
				"name"				=> "last_name",
				"type"				=> "text",
				"label"				=> "Last Name",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->last_name
			),
			array(
				"name"				=> "user_country",
				"type"				=> "text",
				"label"				=> "Country",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->user_country
			)

		) );
		$this->print_fields( $fields );
	}
	
	
	public function stripe_info_fields( ){

		$fields = apply_filters( 'wp_easycart_admin_stripe_info_fields_list', array(
			array(
				"name"				=> "stripe_subscription_id",
				"type"				=> "text",
				"label"				=> "Subscription ID",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->stripe_subscription_id
			),
			array(
				"name"				=> "stripe_customer_id",
				"type"				=> "text",
				"label"				=> "Customer ID",
				"required" 			=> true,
				"message" 			=> "Please enter a unique customer id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->stripe_customer_id
			),
			array(
				"name"				=> "payment_duration",
				"type"				=> "text",
				"label"				=> "Payment Duration",
				"required" 			=> true,
				"read-only"			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"value"				=> $this->subscription->payment_duration
			),
			array(
				"name"				=> "quantity",
				"type"				=> "text",
				"label"				=> "Quantity",
				"required" 			=> true,
				"read-only"			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"value"				=> $this->subscription->quantity
			)

		) );
		$this->print_fields( $fields );
	}
	
	public function paypal_info_fields( ){

		$fields = apply_filters( 'wp_easycart_admin_paypal_info_fields_list', array(
			array(
				"name"				=> "paypal_txn_id",
				"type"				=> "text",
				"label"				=> "PayPal Txn ID",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->paypal_txn_id
			),
			array(
				"name"				=> "paypal_txn_type",
				"type"				=> "text",
				"label"				=> "PayPal Txn Type",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->paypal_txn_type
			),
			array(
				"name"				=> "paypal_subscr_id",
				"type"				=> "text",
				"label"				=> "Subscriber ID",
				"required" 			=> true,
				"message" 			=> "Please enter a unique subscription id.",
				"validation_type" 	=> 'text',
				"read-only"			=> true,
				"value"				=> $this->subscription->paypal_subscr_id
			)

		) );
		$this->print_fields( $fields );
	}

	
}