/*global jQuery, Backbone, _ */
( function ($, Vue, _) {
    'use strict';

    $(document).ready(function () {
        Vue.component('learn-press-modal-search-users', {
            template: '#learn-press-modal-search-users',
            data: function () {
                return {
                    paged: 1,
                    term: '',
                    hasUsers: false,
                    selected: []
                }
            },
            watch: {
                show: function (value) {
                    if (value) {
                        $(this.$refs.search).focus();
                    }
                }
            },
            props: ['multiple', 'context', 'contextId', 'show', 'callbacks', 'textFormat', 'exclude'],
            created: function () {

            },
            methods: {
                doSearch: function (e) {
                    this.term = e.target.value;
                    this.paged = 1;
                    this.search();
                },
                search: _.debounce(function (term) {
                    var that = this;
                    Vue.http.post(
                        window.location.href, {
                            type: this.postType,
                            context: this.context,
                            context_id: this.contextId,
                            term: term || this.term,
                            paged: this.paged,
                            multiple: this.multiple ? 'yes': 'no',
                            text_format: this.textFormat,
                            exclude: this.exclude,
                            'lp-ajax': 'modal_search_users'
                        }, {
                            emulateJSON: true,
                            params: {}
                        }
                    ).then(function (response) {

                        var result = LP.parseJSON(response.body || response.bodyText);
                        that.hasUsers = !!_.size(result.users);

                        $(that.$el).find('.search-results').html(result.html).find('input[type="checkbox"]').each(function () {
                            var id = parseInt($(this).val());
                            if (_.indexOf(that.selected, id) >= 0) {
                                this.checked = true;
                            }
                        });
                        _.debounce(function () {
                            $(that.$el).find('.search-nav').html(result.nav).find('a, span').addClass('button').filter('span').addClass('disabled');
                        }, 10)();
                    });
                }, 500),
                loadPage: function (e) {
                    e.preventDefault();
                    var $button = $(e.target);
                    if ($button.is('span')) {
                        return;
                    }
                    if ($button.hasClass('next')) {
                        this.paged++;
                    } else if ($button.hasClass('prev')) {
                        this.paged--;
                    } else {
                        var paged = $button.html();
                        this.paged = parseInt(paged);
                    }
                    this.search();
                },
                selectItem: function (e) {
                    var $select = $(e.target).closest('li'),
                        $chk = $select.find('input[type="checkbox"]'),
                        id = parseInt($chk.val()),
                        //pos = _.indexOf(this.selected, id),
                        pos = _.findLastIndex(this.selected, {id: id});
                    if(this.multiple) {
                        if ($chk.is(':checked')) {
                            if (pos === -1) {
                                this.selected.push($select.closest('li').data('data'));
                            }
                        } else {
                            if (pos >= 0) {
                                this.selected.splice(pos, 1);
                            }
                        }
                    }else{
                        e.preventDefault();
                        this.selected = [$select.closest('li').data('data')];
                        this.addUsers();
                    }
                },
                addUsers:function(){
                    var $els = $(this.$el).find('.lp-result-item');
                    if(this.callbacks && this.callbacks.addUsers){
                        this.callbacks.addUsers.call(this, this.selected);
                    }
                    $(document).triggerHandler('learn-press/modal-add-users', this.selected);
                },
                close: function () {
                    this.$emit('close');
                }
            }
        });

        window.LP.$modalSearchUsers = new Vue({
            el: '#vue-modal-search-users',
            data: {
                show: false,
                term: '',
                multiple: false,
                callbacks: {},
                textFormat: '{{display_name}} ({{email}})',
                exclude: 0
            },
            methods: {
                open: function (options) {
                    _.each(options.data, function (v, k) {
                        this[k] = v;
                    }, this);
                    this.callbacks = options.callbacks;
                    this.focusSearch();
                },
                close: function () {
                    this.show = false;
                },
                focusSearch: _.debounce(function(){
                    $('input[name="search"]', this.$el).focus();
                }, 200)
            }
        });
    });

}(jQuery, Vue, _));
