<?php
/**
 * User Courses tab
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 2.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

global $post;

$limit = 9;
$paged =  get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;

if ( RDTheme::$profile_current_page != 'courses' ) {
    $paged = 1;
}

$courses   = $user->get( 'courses', array( 'limit' => $limit, 'paged' => $paged ) );
$num_pages = learn_press_get_num_pages( $user->_get_found_rows(), $limit );

$user_id   = learn_press_get_current_user_id();

if ( !$courses ) {
    learn_press_display_message( esc_html__( 'No course found', 'eikra' ) );
    return;
}
?>
<div class="row auto-clear">
    <?php foreach ( $courses as $post ): ?>
        <?php setup_postdata( $post ); ?>
        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
            <?php
            $rdtheme_course_style = RDTheme::$options['course_style'];
            if ( RDTheme::$options['course_style'] != 1 ) {
                learn_press_get_template( "custom/course-box-{$rdtheme_course_style}.php" );
            }
            else {
                learn_press_get_template( 'custom/course-box.php' );
            }
            ?>
        </div>
        <?php wp_reset_postdata(); ?>
    <?php endforeach; ?>
</div>
<?php
learn_press_paging_nav( 
    array(
        'num_pages' => $num_pages,
        'paged'     => $paged,
        'base'      => learn_press_user_profile_link( $user_id, LP()->settings->get( 'profile_endpoints.profile-courses' ) )
    ) 
);