<?php
/**
 * User Profile tabs
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 1.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

RDTheme::$profile_current_page = $args["current"];

$is_instructor = false;
if ( user_can( $user->id, LP_TEACHER_ROLE ) ) {
	$is_instructor = true;
	$instructor_info = get_the_author_meta( 'rt_lp_instructor_info', $user->id );
	$socials = isset( $instructor_info['socials'] ) ? $instructor_info['socials'] : array();
	$socials = array_filter( $socials );
	$socials_fields = RDTheme_Helper::instructor_socials();
}

// Modify Course Title based on user type
$course_title = false;

if ( $is_instructor ) {
	// Instructor visits own profile
	if ( learn_press_get_current_user()->id == $user->ID ){
		$course_title = esc_html__( 'My Published Courses', 'eikra' );
	}
	// Anybody visits instructor profile
	else {
		$course_title = esc_html__( 'Courses by this Instructor', 'eikra' );
	}
}
else {
	// Student visits own profile
	if ( learn_press_get_current_user()->id == $user->ID ){
		$course_title = esc_html__( 'My Enrolled Courses', 'eikra' );
	}
	// Anybody visits student profile
	else {
		$course_title = esc_html__( 'Enrolled Courses', 'eikra' );
	}
}
?>
<div class="row">
	<div class="col-lg-9 col-md-9 col-sm-8 col-xs-12">
		<div class="rt-lp-profile-tab-contents tab-content">
			<?php foreach ( $tabs as $key => $tab ) : ?>
				<?php
				if ( !learn_press_current_user_can_view_profile_section( $key, $user ) ) {
					continue;
				}
				$active_class = ( $key == $args["current"] ) ? ' active in' : '';

				if ( $key == 'courses' && $course_title ) {
					$rdtheme_title = $course_title;
				}
				else {
					$rdtheme_title = $tab['title'];
				}
				?>
				<div class="tab-pane fade<?php echo esc_attr( $active_class ); ?>" id="rt-lp-profile-<?php echo esc_attr( sanitize_title( $tab['title'] ) ); ?>">
					<h3 class="rt-lp-title"><?php echo esc_html( $rdtheme_title ); ?></h3>
					<?php if ( is_callable( $tab['callback'] ) ): ?>
						<?php echo call_user_func_array( $tab['callback'], array( $key, $tab, $user ) ); ?>
					<?php endif; ?>
				</div>
			<?php endforeach; ?>
		</div>
	</div>
	<div class="col-lg-3 col-md-3 col-sm-4 col-xs-12">
		<ul class="rt-lp-profile-tab-nav">
			<?php foreach ( $tabs as $key => $tab ) : ?>
				<?php
				if ( !learn_press_current_user_can_view_profile_section( $key, $user ) ) {
					continue;
				}
				$active_class = ( $key == $args["current"] ) ? ' active' : '';
				?>
				<li class="<?php echo esc_attr( $active_class ); ?>"><a href="#rt-lp-profile-<?php echo esc_attr( sanitize_title( $tab['title'] ) ); ?>" data-toggle="tab" aria-expanded="false"><?php echo esc_html( $tab['title'] ); ?></a></li>
			<?php endforeach; ?>
		</ul>
		<div class="rt-lp-profile-info">
			<h3 class="user-nicename"><?php echo esc_html( learn_press_get_profile_display_name( $user ) ); ?></h3>
			<div class="user-avatar"><?php echo wp_kses_post( $user->get_profile_picture() ); ?></div>
			<div class="user-basic-info">
				<?php if ( $is_instructor && !empty( $instructor_info['designation'] ) ) : ?>
					<div class="user-designation"><?php echo esc_html( $instructor_info['designation'] ); ?></div>
				<?php endif; ?>
				<?php if ( $description = get_user_meta( $user->id, 'description', true ) ): ?>
					<div class="user-bio"><?php echo wp_kses_post( $description ); ?></div>
				<?php endif; ?>
			</div>
			<?php if ( !empty( $socials ) ) : ?>
				<ul class="rtin-social rt-lp-socials">
					<?php foreach ( $socials as $key => $value ): ?>
						<li><a href="<?php echo esc_url(  $value ); ?>" target="_blank"><i class="fa <?php echo esc_attr( $socials_fields[$key]['icon'] ); ?>"></i></a></li>
					<?php endforeach; ?>
				</ul>
			<?php endif; ?>
		</div>
		<?php if ( learn_press_get_current_user()->id == $user->ID ): ?>
			<a class="profile-logout-btn" href="<?php echo esc_url( wp_logout_url() ); ?>"><?php esc_html_e( 'Logout', 'eikra' ) ?></a>
		<?php endif; ?>
	</div>
</div>