<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 2.5
 */

if ( !class_exists( 'RDTheme' ) ) {

	class RDTheme {

		protected static $instance = null;

		// Sitewide static variables
		public static $options = null;
		public static $event_socials = null;
		public static $profile_current_page = null;
		public static $lp_global_script = null;

		// Template specific variables
		public static $layout = null;
		public static $sidebar = null;
		public static $tr_header = null;
		public static $top_bar = null;
		public static $top_bar_style = null;
		public static $header_style = null;
		public static $padding_top = null;
		public static $padding_bottom = null;
		public static $has_banner = null;
		public static $has_breadcrumb = null;
		public static $bgtype = null;
		public static $bgimg = null;
		public static $bgcolor = null;

		private function __construct() {	
			$this->redux_init();
			$this->vc_init();
			$this->layerslider_init();
			add_action( 'after_setup_theme', array( $this, 'set_redux_option' ) );
			add_action( 'after_setup_theme', array( $this, 'set_redux_compability_options' ) );
			add_action( 'init', array( $this, 'rewrite_flush_check' ) );
		}

		public static function instance() {
			if ( null == self::$instance ) {
				self::$instance = new self;
			}
			return self::$instance;
		}

		public function redux_init() {
			add_action( 'admin_menu', array( $this, 'remove_redux_menu' ), 12 ); // Remove Redux Menu
			add_filter( 'redux/eikra/aURL_filter', '__return_empty_string' ); // Remove Redux Ads

			// Flash permalink after options changed
			add_action( 'redux/options/eikra/saved', array( $this, 'flush_redux_saved' ), 10, 2 );
			add_action( 'redux/options/eikra/section/reset', array( $this, 'flush_redux_reset' ) );
			add_action( 'redux/options/eikra/reset', array( $this, 'flush_redux_reset' ) );
		}

		public function vc_init() {
			if ( function_exists('vc_updater') ) {
				remove_filter( 'upgrader_pre_download', array( vc_updater(), 'preUpgradeFilter' ), 10);
				remove_filter( 'pre_set_site_transient_update_plugins', array( vc_updater()->updateManager(), 'check_update' ) );				
			}
		}

		public function layerslider_init() {
			add_action( 'layerslider_ready', array( $this, 'disable_layerslider_autoupdate' ) );
			add_action( 'admin_init', array( $this, 'layerslider_disable_plugin_notice' ) ); // Remove LayerSlider purchase notice from plugins page

			if ( !is_admin() || !apply_filters( 'rdtheme_disable_layerslider_autoupdate', true ) || get_option( 'layerslider-authorized-site' ) ) return;

			// Fix issue of Layerslider update via TGM. Side effect: autoupdate disabled permanently
			global $LS_AutoUpdate;
			if ( isset( $LS_AutoUpdate ) && defined( 'LS_ROOT_FILE' ) ) {
				remove_filter( 'pre_set_site_transient_update_plugins', array( $LS_AutoUpdate, 'set_update_transient' ) );
				remove_filter( 'plugins_api', array( $LS_AutoUpdate, 'set_updates_api_results'), 10, 3 );
				remove_filter( 'upgrader_pre_download', array( $LS_AutoUpdate, 'pre_download_filter' ), 10, 4 );
				remove_filter( 'in_plugin_update_message-'.plugin_basename( LS_ROOT_FILE ), array( $LS_AutoUpdate, 'update_message' ) );
				remove_filter( 'wp_ajax_layerslider_authorize_site', array( $LS_AutoUpdate, 'handleActivation' ) );
				remove_filter( 'wp_ajax_layerslider_deauthorize_site', array( $LS_AutoUpdate, 'handleDeactivation' ) );
			}
		}

		public function layerslider_disable_plugin_notice() {
			if ( defined( 'LS_PLUGIN_BASE' ) ) {
				remove_action( 'after_plugin_row_' . LS_PLUGIN_BASE, 'layerslider_plugins_purchase_notice', 10, 3 );
			}
		}

		public function disable_layerslider_autoupdate() {
			$GLOBALS['lsAutoUpdateBox'] = false;
		}

		public function set_redux_option(){
			if ( ! class_exists( 'Redux' ) ) {
				include RDTHEME_INC_DIR . 'redux-data.php';
				self::$options = json_decode( $rdtheme_redux_data, true );
				return;
			}		
			global $eikra;
			self::$options = $eikra;

			// Prevent Redux first activation error on admin
			if ( is_admin() && count( self::$options ) < 3 ) {
				include RDTHEME_INC_DIR . 'redux-data.php';
				self::$options = json_decode( $rdtheme_redux_data, true );
			}
		}

		// Backward compability for newly added options
		public function set_redux_compability_options(){
			$new_options = array(
				'event_time_format' => '24',
				'payment_img'       => false,
				'course_price_hide' => false,
				'course_meta'       => array(
					'ins' => '1', 
					'lec' => '1', 
					'qz'  => '1',
					'stu' => '1',
					'dur' => '1',
				),
				'course_cats'       => true,
				'course_tags'       => true,
				'course_curriculum' => true,
				'course_instructor' => true,
				'course_review'     => true,
				'course_related'    => true,
				'course_sidebar'    => true,
				'course_progress'   => true,
				'course_price'      => true,
				'course_rating'     => true,
			);

			foreach ( $new_options as $key => $value ) {
				if ( !isset( self::$options[$key] ) ) {
					self::$options[$key] = $value;
				}	    	
			}
		}

		public function remove_redux_menu() {
			remove_submenu_page('tools.php','redux-about');
		}

		// Flush rewrites
		public function flush_redux_saved( $saved_options, $changed_options ){
			if ( empty( $changed_options ) ) {
				return;
			}
			$flush = false;
			$slugs = array( 'research_slug', 'event_slug', 'course_slug', 'instructor_slug' );
			foreach ( $slugs as $slug ) {
				if ( array_key_exists( $slug, $changed_options ) ) {
					$flush = true;
				}
			}

			if ( $flush ) {
				update_option( 'eikra_rewrite_flash', true );
			}
		}

		public function flush_redux_reset(){
			update_option( 'eikra_rewrite_flash', true );
		}

		public function rewrite_flush_check() {
			if ( get_option('eikra_rewrite_flash') == true ) {
				flush_rewrite_rules();
				update_option( 'eikra_rewrite_flash', false );
			}
		}
	}
}

RDTheme::instance();

// Remove Redux NewsFlash
if ( ! class_exists( 'reduxNewsflash' ) ){
	class reduxNewsflash {
		public function __construct( $parent, $params ) {}
	}
}