<?php
/**
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 1.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$user         = learn_press_get_current_user();
$course       = learn_press_get_the_course();
$section_name = apply_filters( 'learn_press_curriculum_section_name', $section->section_name, $section );
$force        = isset( $force ) ? $force : false;

if ( $section_name === false ) {
	return;
}
?>
<h4 class="section-header">
	<span class="title"><?php echo esc_html( $section_name ); ?></span>
	<span class="meta">
		<span class="step"><?php printf( esc_html__( '%d/%d', 'eikra' ), $user->get_completed_items_in_section( $course->id, $section->section_id, $force ), sizeof( $section->items ) ); ?></span>
		<span class="collapse"></span>
	</span>
</h4>
<?php if ( $section_description = apply_filters( 'learn_press_curriculum_section_description', $section->section_description, $section ) ): ?>
	<p class="section-description"><?php echo wp_kses_post( $section_description ); ?></p>
<?php endif; ?>