<?php
/**
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 1.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$course     = LP()->global['course'];
$viewable   = learn_press_user_can_view_lesson( $item->ID, $course->id );
$tag        = $viewable ? 'a' : 'span';
$target     = apply_filters( 'learn_press_section_item_link_target', '_blank', $item );
$item_title = apply_filters( 'learn_press_section_item_title', get_the_title( $item->ID ), $item );
$item_link  = $viewable ? 'href="' . $course->get_item_link( $item->ID ) . '"' : '';

$index_html = esc_html__( 'Lecture', 'eikra' );
$index_html = "<span>$index_html </span>$index";

$duration = rdtheme_lp_lesson_duration( $item->ID );
if ( $duration ) {
	$item_right_html = '<i class="fa fa-clock-o" aria-hidden="true"></i><span>'.$duration.'</span>';
	$item_class = '';
}
else {
	$item_right_html = '';
	$item_class = 'no-counting';
}
?>
<li <?php learn_press_course_item_class( $item->ID, 0 , $item_class ); ?> data-type="<?php echo esc_attr( $item->post_type ); ?>">
	<div class="rtin-left">
		<span class="rtin-left-icon"><i class="fa fa-file-text-o"></i></span>
		<span class="rtin-left-index"><?php echo wp_kses_post( $index_html ); ?></span>
	</div>
	<div class="rtin-center">
		<?php do_action( 'learn_press_before_section_item_title', $item, $section, $course ); ?>
		<<?php echo esc_html( $tag ); ?> class="course-item-title button-load-item" <?php print( $item_link ); ?> data-id="<?php echo esc_attr( $item->ID ); ?>" data-complete-nonce="<?php echo wp_create_nonce( 'learn-press-complete-' . $item->post_type . '-' . $item->ID ); ?>"><?php echo esc_html( $item_title ); ?></<?php echo esc_html( $tag ); ?>>
		<?php do_action( 'learn_press_after_section_item_title', $item, $section, $course ); ?>
	</div>
	<div class="rtin-right"><?php echo wp_kses_post( $item_right_html );?></div>
	<div class="clear"></div>
</li>