<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 2.5
 */

$rdtheme_theme_data = wp_get_theme( get_template() );
if ( function_exists('vc_is_inline') && vc_is_inline() ) {
	define( 'EIKRA_VERSION', time() );
}
else {
	define( 'EIKRA_VERSION', ( WP_DEBUG ) ? time() : $rdtheme_theme_data->get( 'Version' ) );
}

define( 'RDTHEME_AUTHOR_URI',  $rdtheme_theme_data->get( 'AuthorURI' ) );
define( 'RDTHEME_PREFIX',      'eikra' );

// DIR
define( 'RDTHEME_BASE_DIR',    get_template_directory(). '/' );
define( 'RDTHEME_INC_DIR',     RDTHEME_BASE_DIR . 'inc/' );
define( 'RDTHEME_VIEW_DIR',    RDTHEME_INC_DIR . 'views/' );
define( 'RDTHEME_PLUGINS_DIR', RDTHEME_INC_DIR . 'plugins/' );

// URL
define( 'RDTHEME_BASE_URL',    get_template_directory_uri(). '/' );
define( 'RDTHEME_ASSETS_URL',  RDTHEME_BASE_URL . 'assets/' );
define( 'RDTHEME_CSS_URL',     RDTHEME_ASSETS_URL . 'css/' );
define( 'RDTHEME_AUTORTL_URL', RDTHEME_ASSETS_URL . 'css-auto-rtl/' );
define( 'RDTHEME_JS_URL',      RDTHEME_ASSETS_URL . 'js/' );
define( 'RDTHEME_IMG_URL',     RDTHEME_ASSETS_URL . 'img/' );

// Includes
require_once RDTHEME_INC_DIR . 'helper-functions.php';
RDTheme_Helper::requires( 'class-tgm-plugin-activation.php' );
RDTheme_Helper::requires( 'tgm-config.php' );
RDTheme_Helper::requires( 'redux-config.php' );
RDTheme_Helper::requires( 'rdtheme.php' );
RDTheme_Helper::requires( 'general.php' );
RDTheme_Helper::requires( 'scripts.php' );
RDTheme_Helper::requires( 'layout-settings.php' );
RDTheme_Helper::requires( 'sidebar-generator.php' );
RDTheme_Helper::requires( 'vc-settings.php' );

// Widgets
RDTheme_Helper::requires( 'about-widget.php', 'inc/widgets' );
RDTheme_Helper::requires( 'info-widget.php', 'inc/widgets' );

// Learnpress
if ( RDTheme_Helper::is_LMS() ) {
	if ( RDTheme_Helper::lp_is_v2() ) {
		RDTheme_Helper::requires( 'lp-functions.php', 'learnpress-v2/custom/inc' );
		RDTheme_Helper::requires( 'lp-hooks.php', 'learnpress-v2/custom/inc' );
	}
	else {
		RDTheme_Helper::requires( 'lp-functions.php', 'learnpress/custom/inc' );
		RDTheme_Helper::requires( 'lp-hooks.php', 'learnpress/custom/inc' );
	}
}

// WooCommerce
if ( class_exists( 'WooCommerce' ) ) {
	RDTheme_Helper::requires( 'woo-functions.php' );
	RDTheme_Helper::requires( 'woo-hooks.php' );
}


@ini_set( 'upload_max_size' , '64M' );
@ini_set( 'post_max_size', '64M');
@ini_set( 'max_execution_time', '300' );
register_sidebar( array(
'name' => 'header Sidebar 1',
'id' => 'header-sidebar-1',
'description' => 'Appears in the footer area',
'before_widget' => '<aside id="%1$s" class="widget %2$s">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );

add_filter( 'http_request_args', function( $params, $url )
{
	add_filter( 'https_ssl_verify', '__return_false' );

	return $params;
}, 10, 2 );

add_action('wpeasycart_order_inserted',function (){
	$cart_data = $GLOBALS['ec_cart_data']->cart_data;
	if(empty($cart_data->username2)) return false;
	$phone = $cart_data->billing_phone?$cart_data->billing_phone:$cart_data->shipping_phone?$cart_data->shipping_phone:'';
	$args = [
		'secret'    => 'investitwp',
		'firstname' => $cart_data->first_name,
		'lastname'  => $cart_data->last_name,
		'email'     => $cart_data->email,
		'username'  => $cart_data->username2,
		'password'  => $cart_data->password2,
		'phone'     => $phone,
	];

	$response = wp_remote_post('https://public.investitacademylms.com/moodle/local/user_create.php',array(
		'method' => 'POST',
		'timeout' => 45,
		'redirection' => 5,
		'httpversion' => '1.0',
		'blocking' => true,
		'headers' => array(),
		'body' => $args,
		'cookies' => array()
	));

	$fp = fopen('order.txt', 'w');
	fwrite($fp, print_r($response,true));
	fclose($fp);
});



add_filter( 'wpeasycart_validate_checkout_data', function ( $validated, $user ){

	$username = $_REQUEST['ec_contact_username'];
	$args = ['secret'=> 'investitwp', 'username'=>$username];

	$response = wp_remote_post('https://public.investitacademylms.com/moodle/local/check_user.php',array(
		'method' => 'POST',
		'timeout' => 45,
		'redirection' => 5,
		'httpversion' => '1.0',
		'blocking' => true,
		'headers' => array(),
		'body' => $args,
		'cookies' => array()
	));

	$res = json_decode($response['body']);
	$fp = fopen('order.txt', 'w');
	fwrite($fp, $username.'__'.print_r($response['body'],true));
	fclose($fp);
	if($res->error == 1) {
		wp_redirect( site_url() . "/cart?ec_page=checkout_info&ec_cart_error=invalid_username" );
		die;
		return false;
	}
	return $validated;
}
	, 10, 2
);
function captcha_addition(){
    $ec_option_enable_recaptcha="";
    $ec_option_recaptcha_site_key = "6LfKXXsUAAAAAOJ9GhgFvf_wYVNlYwt6BOjfUqqg";
    $ec_option_recaptcha_secret_key = "6LfKXXsUAAAAAMyr5LBlPwkv1W_uNC8sZjBscQNw";
    //$ec_option_recaptcha_secret_key = get_option('ec_option_recaptcha_secret_key');
    ?>
    <input type="hidden" id="ec_grecaptcha_response_checkout" name="ec_grecaptcha_response_checkout" value="" />
    <input type="hidden" id="ec_grecaptcha_site_key" value="<?php echo $ec_option_recaptcha_site_key; ?>" />
    <div class="ec_cart_input_row" data-sitekey="<?php echo $ec_option_recaptcha_site_key; ?>" id="ec_account_checkout_recaptcha"></div>
    <?
    if(get_option( 'ec_option_enable_recaptcha' ) && get_option( 'ec_option_recaptcha_site_key' ) != '') return;
    wp_enqueue_script( 'wpeasycart_google_recaptcha_js', 'https://www.google.com/recaptcha/api.js?onload=wpeasycart_recaptcha_onload&render=explicit', array( ), EC_CURRENT_VERSION, false );
}
//add_action('wpeasycart_order_notes_after','captcha_addition');

function captcha_validate(){
    $recaptcha_valid =false;
    if($GLOBALS['ec_cart_data']->cart_data->user_id) $recaptcha_valid =true;
    if( !empty($_POST['g-recaptcha-response']) ){
        $recaptcha_response = $_POST['g-recaptcha-response'];
        $data = array(
            "secret"	=> '6Lep8nIUAAAAAIqJ0MAfOdFjX8ASKRQtzEfv0N7H',
            "response"	=> $recaptcha_response
        );
        $verify = curl_init();
        curl_setopt( $verify, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify" );
        curl_setopt( $verify, CURLOPT_POST, true );
        curl_setopt( $verify, CURLOPT_POSTFIELDS, http_build_query( $data ) );
        curl_setopt( $verify, CURLOPT_SSL_VERIFYPEER, false );
        curl_setopt( $verify, CURLOPT_RETURNTRANSFER, true );
        $response = curl_exec( $verify );
        $recaptcha_valid = $response["success"];
    }
    if(!$recaptcha_valid){
        $cart_page = get_permalink(get_option('ec_option_cartpage'));
        header( "location: " . $cart_page . "?ec_page=checkout_info&ec_cart_error=fill_captcha" );
        exit;
    }
    return $recaptcha_valid;
}
add_filter('wpeasycart_validate_checkout_data','captcha_validate');

//* TN - Remove Query String from Static Resources
function remove_css_js_ver( $src ) {
if( strpos( $src, '?ver=' ) )
$src = remove_query_arg( 'ver', $src );
return $src;
}
add_filter( 'style_loader_src', 'remove_css_js_ver', 10, 2 );
add_filter( 'script_loader_src', 'remove_css_js_ver', 10, 2 );