<?php
/**
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 2.1.6
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$course      = LP()->global['course'];
$viewable    = learn_press_user_can_view_quiz( $item->ID, $course->id );
$tag         = $viewable ? 'a' : 'span';
$target      = apply_filters( 'learn_press_section_item_link_target', '_blank', $item );
$item_title  = apply_filters( 'learn_press_section_item_title', get_the_title( $item->ID ), $item );
$item_link   = $viewable ? 'href="' . $course->get_item_link( $item->ID ) . '"' : '';

$index_html = esc_html__( 'Quiz', 'eikra' );
$index_html = "<span>$index_html </span>$index";

$quiz_count = rdtheme_lp_quiz_ques_count( $item->ID );
if ( $quiz_count ) {
	$item_right_html  = $quiz_count. ' ';
	$item_right_html .= ( $quiz_count > 1 ) ? esc_html__( 'Questions', 'eikra' ) : esc_html__( 'Question', 'eikra' );
	$item_class = '';
}
else {
	$item_right_html = '';
	$item_class = 'no-counting';
}

$user = learn_press_get_current_user();
$item_status = $user->get_item_status( $item->ID );
if ( in_array( $item_status, array( 'completed', 'started' ) ) ) {
	$item_class .= ' item-has-result';
}
?>
<li <?php learn_press_course_item_class( $item->ID, 0 , $item_class ); ?> data-type="<?php echo esc_attr( $item->post_type ); ?>">
	<div class="rtin-left">
		<span class="rtin-left-icon"><i class="fa fa-pencil-square-o"></i></span>
		<span class="rtin-left-index"><?php echo wp_kses_post( $index_html ); ?></span>
	</div>
	<div class="rtin-center">
		<?php do_action( 'learn_press_before_section_item_title', $item, $section, $course ); ?>
		<<?php echo esc_html( $tag ); ?> class="course-item-title button-load-item" <?php print( $item_link ); ?> data-id="<?php echo esc_attr( $item->ID ); ?>" data-complete-nonce="<?php echo wp_create_nonce( 'learn-press-complete-' . $item->post_type . '-' . $item->ID ); ?>"><?php echo esc_html( $item_title ); ?></<?php echo esc_html( $tag ); ?>>
		<?php do_action( 'learn_press_after_section_item_title', $item, $section, $course ); ?>
	</div>
	<div class="rtin-right"><?php echo wp_kses_post( $item_right_html );?></div>
	<div class="clear"></div>
</li>