<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.3
 */

/*-------------------------------------
#. Remove Ads
---------------------------------------*/
remove_action( 'admin_footer', 'learn_press_advertise_in_admin', - 10 ); // remove footer advertisements
add_filter( 'learn_press_display_admin_footer_text', '__return_false' ); // remove footer rating text

/*-------------------------------------
#. Course Archive
---------------------------------------*/
remove_action( 'learn_press_before_main_content', 'learn_press_breadcrumb' );
remove_action( 'learn_press_before_main_content', 'learn_press_search_form' );
remove_action( 'learn_press_after_courses_loop_item', 'learn_press_courses_loop_item_begin_meta', 10 );
remove_action( 'learn_press_after_courses_loop_item', 'learn_press_courses_loop_item_instructor', 15 );
remove_action( 'learn_press_after_courses_loop_item', 'learn_press_courses_loop_item_students', 20 );
remove_action( 'learn_press_after_courses_loop_item', 'learn_press_courses_loop_item_price', 25 );
remove_action( 'learn_press_after_courses_loop_item', 'learn_press_courses_loop_item_end_meta', 30 );

/*-------------------------------------
#. Course Single
---------------------------------------*/
// When user not enrolled
remove_action( 'learn_press_content_landing_summary', 'learn_press_course_meta_start_wrapper', 15 );
remove_action( 'learn_press_content_landing_summary', 'learn_press_course_price', 25 );
remove_action( 'learn_press_content_landing_summary', 'learn_press_course_students', 30 );
remove_action( 'learn_press_content_landing_summary', 'learn_press_course_meta_end_wrapper', 35 );
remove_action( 'learn_press_content_landing_summary', 'learn_press_single_course_content_lesson', 40 );
remove_action( 'learn_press_content_landing_summary', 'learn_press_single_course_content_item', 40 );
remove_action( 'learn_press_content_landing_summary', 'learn_press_course_progress', 60 );
remove_action( 'learn_press_content_landing_summary', 'learn_press_course_buttons', 70 );

// When user enrolled
remove_action( 'learn_press_content_learning_summary', 'learn_press_course_meta_start_wrapper', 10 );
remove_action( 'learn_press_content_learning_summary', 'learn_press_course_status', 15 );
remove_action( 'learn_press_content_learning_summary', 'learn_press_course_instructor', 20 );
remove_action( 'learn_press_content_learning_summary', 'learn_press_course_students', 25 );
remove_action( 'learn_press_content_learning_summary', 'learn_press_course_meta_end_wrapper', 30 );
remove_action( 'learn_press_content_learning_summary', 'learn_press_single_course_content_lesson', 35 );
remove_action( 'learn_press_content_learning_summary', 'learn_press_single_course_content_item', 40 );
remove_action( 'learn_press_content_learning_summary', 'learn_press_course_progress', 45 );
remove_action( 'learn_press_content_learning_summary', 'learn_press_course_buttons', 65 );

// Include features before description
add_action( 'learn_press_begin_single_course_description', 'rdtheme_lp_course_features' );

// Remove wishlist from default position
if ( class_exists( 'LP_Addon_Wishlist' ) ) {
	$rdtheme_wishlist = LP_Addon_Wishlist::instance();
	remove_action( 'learn_press_content_learning_summary', array( $rdtheme_wishlist, 'wishlist_button' ), 100 );
}

// Sort tabs by priority
add_filter( 'learn_press_course_tabs', 'rdtheme_lp_sort_tabs' );

// Add instructor tab
add_filter( 'learn_press_course_tabs', 'rdtheme_lp_instructor_tab' , 5 );

// Show overview tab even if no contents
add_filter( 'learn_press_course_tabs', 'rdtheme_lp_show_overview_tab_always' , 5 );

// Modify empty curriculam text
add_filter( 'learn_press_course_curriculum_empty', 'rdtheme_lp_empty_curriculum_text' );

// Modify Reviews Tab
if ( class_exists( 'LP_Addon_Course_Review' ) ) {
	add_filter( 'learn_press_course_tabs', 'rdtheme_lp_modify_reviews_tab' , 5 );
}

// Disable Tabs based on theme options
add_filter( 'learn_press_course_tabs', 'rdtheme_lp_disable_tabs', 50 );

// Wishlist Modal
add_action( 'wp_footer', 'rdtheme_lp_wishlist_modal' );

/*-------------------------------------
#. Profile
---------------------------------------*/
add_filter( 'learn_press_page_settings', 'rdtheme_lp_change_avatar_size' ); // change avatar size to 360x370

remove_action( 'learn_press_user_profile_summary', 'learn_press_output_user_profile_info', 5, 3 ); // moved info on sidebar
remove_action( 'learn_press_after_profile_loop_course', 'learn_press_after_profile_tab_loop_course', 5, 2 ); // we are using our own template

/* remove useless actions by base plugin */
remove_action( 'learn_press_user_profile_summary', 'learn_press_output_user_profile_order', 15, 3 );
remove_action( 'learn_press_profile_tab_courses_all', 'learn_press_profile_tab_courses_all', 5, 2 );
remove_action( 'learn_press_profile_tab_courses_learning', 'learn_press_profile_tab_courses_learning', 5, 2 );
remove_action( 'learn_press_profile_tab_courses_purchased', 'learn_press_profile_tab_courses_purchased', 5, 2 );
remove_action( 'learn_press_profile_tab_courses_finished', 'learn_press_profile_tab_courses_finished', 5, 2 );
remove_action( 'learn_press_profile_tab_courses_own', 'learn_press_profile_tab_courses_own', 5, 2 );
remove_action( 'learn_press_after_profile_tab_all_loop_course', 'learn_press_after_profile_tab_loop_course', 5, 2 );
remove_action( 'learn_press_after_profile_tab_own_loop_course', 'learn_press_after_profile_tab_loop_course', 5, 2 );

/*-------------------------------------
#. Instructor backend
---------------------------------------*/
if ( is_admin() && current_user_can( 'lp_teacher' ) && !current_user_can( 'administrator' ) ) {
	add_action( 'admin_menu', 'rdtheme_lp_instructor_admin_menu' ); // hide all admin menus except Learpress and Profile
	add_action( 'add_admin_bar_menus', 'rdtheme_lp_instructor_admin_bar_menu' ); // hide some admin bar menus
	add_action( 'load-index.php', 'rdtheme_lp_instructor_admin_index' ); // set Course Page as default instead of dashboard
}

/*-------------------------------------
#. Instructor extra fields
---------------------------------------*/
// Create fields in backend
add_action( 'show_user_profile', 'rdtheme_lp_instructor_extra_fields' );
add_action( 'edit_user_profile', 'rdtheme_lp_instructor_extra_fields' );

// Save fields in backend
add_action( 'personal_options_update', 'rdtheme_lp_instructor_extra_fields_update' );
add_action( 'edit_user_profile_update', 'rdtheme_lp_instructor_extra_fields_update' );

// Create fields in backend
add_action( 'learn_press_after_basic-information_edit_fields', 'rdtheme_lp_instructor_extra_fields_frontend' );

// Save fields in frontend
add_action( 'learn_press_update_user_profile_basic-information', 'rdtheme_lp_instructor_extra_fields_update', 5 );