<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 2.5
 */

$rdtheme_theme_data = wp_get_theme( get_template() );
if ( function_exists('vc_is_inline') && vc_is_inline() ) {
	define( 'EIKRA_VERSION', time() );
}
else {
	define( 'EIKRA_VERSION', ( WP_DEBUG ) ? time() : $rdtheme_theme_data->get( 'Version' ) );
}

define( 'RDTHEME_AUTHOR_URI',  $rdtheme_theme_data->get( 'AuthorURI' ) );
define( 'RDTHEME_PREFIX',      'eikra' );

// DIR
define( 'RDTHEME_BASE_DIR',    get_template_directory(). '/' );
define( 'RDTHEME_INC_DIR',     RDTHEME_BASE_DIR . 'inc/' );
define( 'RDTHEME_VIEW_DIR',    RDTHEME_INC_DIR . 'views/' );
define( 'RDTHEME_PLUGINS_DIR', RDTHEME_INC_DIR . 'plugins/' );

// URL
define( 'RDTHEME_BASE_URL',    get_template_directory_uri(). '/' );
define( 'RDTHEME_ASSETS_URL',  RDTHEME_BASE_URL . 'assets/' );
define( 'RDTHEME_CSS_URL',     RDTHEME_ASSETS_URL . 'css/' );
define( 'RDTHEME_AUTORTL_URL', RDTHEME_ASSETS_URL . 'css-auto-rtl/' );
define( 'RDTHEME_JS_URL',      RDTHEME_ASSETS_URL . 'js/' );
define( 'RDTHEME_IMG_URL',     RDTHEME_ASSETS_URL . 'img/' );

// Includes
require_once RDTHEME_INC_DIR . 'helper-functions.php';
RDTheme_Helper::requires( 'class-tgm-plugin-activation.php' );
RDTheme_Helper::requires( 'tgm-config.php' );
RDTheme_Helper::requires( 'redux-config.php' );
RDTheme_Helper::requires( 'rdtheme.php' );
RDTheme_Helper::requires( 'general.php' );
RDTheme_Helper::requires( 'scripts.php' );
RDTheme_Helper::requires( 'layout-settings.php' );
RDTheme_Helper::requires( 'sidebar-generator.php' );
RDTheme_Helper::requires( 'vc-settings.php' );

// Widgets
RDTheme_Helper::requires( 'about-widget.php', 'inc/widgets' );
RDTheme_Helper::requires( 'info-widget.php', 'inc/widgets' );

// Learnpress
if ( RDTheme_Helper::is_LMS() ) {
	if ( RDTheme_Helper::lp_is_v2() ) {
		RDTheme_Helper::requires( 'lp-functions.php', 'learnpress-v2/custom/inc' );
		RDTheme_Helper::requires( 'lp-hooks.php', 'learnpress-v2/custom/inc' );
	}
	else {
		RDTheme_Helper::requires( 'lp-functions.php', 'learnpress/custom/inc' );
		RDTheme_Helper::requires( 'lp-hooks.php', 'learnpress/custom/inc' );
	}
}

// WooCommerce
if ( class_exists( 'WooCommerce' ) ) {
	RDTheme_Helper::requires( 'woo-functions.php' );
	RDTheme_Helper::requires( 'woo-hooks.php' );
}


@ini_set( 'upload_max_size' , '64M' );
@ini_set( 'post_max_size', '64M');
@ini_set( 'max_execution_time', '300' );
register_sidebar( array(
'name' => 'header Sidebar 1',
'id' => 'header-sidebar-1',
'description' => 'Appears in the footer area',
'before_widget' => '<aside id="%1$s" class="widget %2$s">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );