<?php
/**
 * Template for displaying user's orders
 *
 * @author  ThimPress
 * @package LearnPress/Template
 * @version x.x
 */
defined( 'ABSPATH' ) || exit();

$user_id     = learn_press_get_current_user_id();
$all_orders  = _learn_press_get_user_profile_orders( $user_id, 1, 99999999 );

if ( empty( $all_orders['rows'] ) ) {
	learn_press_display_message( esc_html__( "You don't have any orders yet", 'eikra' ) );
	return;
}

$total_count = count( $all_orders['rows'] );

$paged =  get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
if ( RDTheme::$profile_current_page != 'orders' ) {
	$paged = 1;
}

$limit = 30;
$num_of_pages = ceil( $total_count / $limit );
$orders = array_slice( $all_orders['rows'], ( $paged - 1 ) * $limit, $limit );
?>
<table class="table-orders">
	<thead>
		<th><?php esc_html_e( 'Order', 'eikra' ); ?></th>
		<th><?php esc_html_e( 'Date', 'eikra' ); ?></th>
		<th><?php esc_html_e( 'Status', 'eikra' ); ?></th>
		<th><?php esc_html_e( 'Total', 'eikra' ); ?></th>
		<th><?php esc_html_e( 'Action', 'eikra' ); ?></th>
	</thead>
	<tbody>
		<?php foreach ( $orders as $order ): $order = learn_press_get_order( $order ); ?>
			<tr>
				<td><?php echo esc_html( $order->get_order_number() ); ?></td>
				<td><?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $order->order_date ) ) ); ?></td>
				<td>
					<?php echo wp_kses_post( $order->get_order_status_html() ); ?>
					<?php
					if ( $order->has_status( 'pending' ) ) :
						printf( '(<small><a href="%s" class="%s">%s</a></small>)', esc_url( $order->get_cancel_order_url() ), 'cancel-order', esc_html__( 'Cancel', 'eikra' ) );
					endif;
					?>
				</td>
				<td><?php echo esc_html( $order->get_formatted_order_total() ); ?></td>
				<td>
					<?php
					$actions['view'] = array(
						'url'  => $order->get_view_order_url(),
						'text' => esc_html__( 'View', 'eikra' )
					);
					$actions = apply_filters( 'learn_press_user_profile_order_actions', $actions, $order );

					foreach ( $actions as $slug => $option ) {
						printf( '<a href="%s">%s</a>', esc_url( $option['url'] ), esc_html( $option['text'] ) );
					}
					?>
				</td>
			</tr>
		<?php endforeach; ?>
	</tbody>
</table>
<?php
learn_press_paging_nav( 
	array(
		'num_pages' => $num_of_pages,
		'paged'     => $paged,
		'base'      => learn_press_user_profile_link( $user_id, LP()->settings->get( 'profile_endpoints.profile-orders' ) )
	) 
);