<?php
if( !defined( 'ABSPATH' ) ) exit;

class wp_easycart_admin_details_coupons extends wp_easycart_admin_details{
	
	public $coupon;
	
	public function __construct( ){
		parent::__construct( );
		add_action( 'wp_easycart_admin_coupon_details_stepone_fields', array( $this, 'stepone_fields' ) );
		add_action( 'wp_easycart_admin_coupon_details_steptwo_fields', array( $this, 'steptwo_fields' ) );
		add_action( 'wp_easycart_admin_coupon_details_stepthree_fields', array( $this, 'stepthree_fields' ) );
		add_action( 'wp_easycart_admin_coupon_details_stepfour_fields', array( $this, 'stepfour_fields' ) );
	}
	
	protected function init( ){
		$this->id = 0;
		$this->page = 'wp-easycart-rates';
		$this->subpage = 'coupons';
		$this->action = 'admin.php?page=' . $this->page . '&subpage=' . $this->subpage;
		$this->form_action = 'add-new-coupon';
		$this->coupon = $this->item = (object) array(
			"promocode_id"					=> "",
			"message"						=> "",
			"times_redeemed"				=> "",
			"max_redemptions"				=> "",
			"expiration_date"				=> "",
			
			"is_dollar_based"				=> "",
			"is_percentage_based"			=> "",
			"is_shipping_based"				=> "",
			"is_free_item_based"			=> "",
			"is_for_me_based"				=> "",
			
			"by_manufacturer_id"			=> "",
			"by_product_id"					=> "",
			"by_all_products"				=> "",
			"by_category_id"				=> "",
			
			"promo_dollar"					=> "",
			"promo_percentage"				=> "",
			"promo_shipping"				=> "",
			"promo_free_item"				=> "0.00",
			"promo_for_me"					=> "",
			
			"manufacturer_id"				=> "",
			"product_id"					=> "",
			"category_id"					=> "",
			
			"duration"						=> "forever",
			"duration_in_months"			=> "1"	
		);
	}
	
	protected function init_data( ){
		$this->form_action = 'update-coupon';
		$this->docs_link = 'http://docs.wpeasycart.com/wp-easycart-administrative-console-guide/?section=coupons';
		$this->item = $this->coupon = $this->wpdb->get_row( $this->wpdb->prepare( "SELECT ec_promocode.* FROM ec_promocode WHERE promocode_id = %s", $_GET['promocode_id'] ) );
		$this->id = $this->coupon->promocode_id;
	}

	public function output( $type = 'edit' ){
		$this->init( );
		if( $type == 'edit' )
			$this->init_data( );
		include( WP_EASYCART_ADMIN_PRO_PLUGIN_DIR . 'admin/template/marketing/coupons/coupon-details.php' );
	}
	
	public function stepone_fields( ){
		$fields = apply_filters( 'wp_easycart_admin_coupon_details_stepone_fields_list', array(
			array(
				"panel"	=> "basic",
				"name"	=> "promocode_id",
				"type"	=> "text",
				"label"	=> "Coupon Code",
				"required" => true,
				"message" => "Please enter a unique Coupon code",
				"validation_type" => 'text',
				"value" => $this->coupon->promocode_id
			),
			array(
				"panel"	=> "basic",
				"name"	=> "message",
				"type"	=> "text",
				"label"	=> "Customer Message",
				"required" => true,
				"message" => "Please enter a unique message to show user upon entering coupon code",
				"validation_type" => 'text',
				"value" => $this->coupon->message
			),
			array(
				"panel"	=> "basic",
				"name"	=> "max_redemptions",
				"type"	=> "number",
				"label"	=> "Maximum Redemptions",
				"decimals" => 0,
				"step"  => 1,
				"required" => true,
				"message" => "Please enter the maximum times this coupon may be used.  999 is unlimited",
				"validation_type" => 'number',
				"value" => $this->coupon->max_redemptions
			),
			array(
				"panel"	=> "basic",
				"name"	=> "times_redeemed",
				"type"	=> "number",
				"label"	=> "Times Redeemed",
				"decimals" => 0,
				"step"  => 1,
				"read-only" => true,
				"required" => false,
				"message" => "",
				"value" => $this->coupon->times_redeemed
			),
			array(
				"panel"	=> "basic",
				"name"	=> "expiration_date",
				"type"	=> "date",
				"label"	=> "Expiration Date",
				"max"	=> date( 'Y-m-d', strtotime( "+5 year" ) ),
				"required" => true,
				"message" => "Expiration date required, max 5 years in the future",
				"validation_type" => 'date',
				"value" => $this->coupon->expiration_date
			),
			array(
				"panel"	=> "basic",
				"name"	=> "duration",
				"type"	=> "select",
				"data"	=> array(
					(object) array(
						"id"	=> "forever",
						"value"	=> "Forever (Applies to all recurring payments)"
					),
					(object) array(
						"id"	=> "once",
						"value"	=> "Once (Applies only to first payment)"
					),
					(object) array(
						"id"	=> "repeating",
						"value"	=> "Apply to Some Limited Number of Months"
					)
				),
				"data_label" => "Please Select a Duration",
				"label"		=> "Duration (Applies to Subscriptions Only)",
				"required" 	=> true,
				"message" => "Choose a coupon duration even if this does not apply to a subscription",
				"validation_type" => 'select',
				"show"  	=> array(
					"name" 	=> "duration_in_months",
					"value"	=> "repeating"
				),
				"value" => $this->coupon->duration
			),
			array(
				"panel"		=> "basic",
				"name"		=> "duration_in_months",
				"type"		=> "number",
				"label"		=> "Duration in Months",
				"required" 	=> false,
				"requires"	=> array(
					array(
						"name"			=> "duration",
						"value"			=> "repeating",
						"default_show"	=> false
					)
				),
				"value" 	=> $this->coupon->duration_in_months
			)
		) );
		$this->print_fields( $fields );
	}
	
	public function steptwo_fields( ){
		$fields = apply_filters( 'wp_easycart_admin_coupon_details_steptwo_fields_list', array(
		
			array(
				"panel"	=> "basic",
				"name"	=> "is_dollar_based",
				"type"	=> "checkbox",
				"label"	=> "Dollar Based Coupon?",
				"required" => false,
				"message" => "",
				"onclick" => "ec_admin_coupon_type_change",
				"selected" => false,
				"show"  => array(
					"name" =>"promo_dollar",
					"value"=>"1"
				),
				"value" => $this->coupon->is_dollar_based
			),
			array(
				"panel"	=> "basic",
				"name"	=> "promo_dollar",
				"type"	=> "currency",
				"label"	=> "Dollar Amount",
				"required" => false,
				"message" => "Please enter a dollar amount this discount will apply",
				"requires"=>array(
					"name"=>"is_dollar_based",
					"value"=>"1",
					"default_show"=> false
				),
				"value" => $this->coupon->promo_dollar
			),
			array(
				"panel"	=> "basic",
				"name"	=> "is_percentage_based",
				"type"	=> "checkbox",
				"label"	=> "Percentage Based Coupon?",
				"required" => false,
				"message" => "",
				"onclick" => "ec_admin_coupon_type_change",
				"selected" => false,
				"show"  => array(
					"name" =>"promo_percentage",
					"value"=>"1"
				),
				"value" => $this->coupon->is_percentage_based
			),
			array(
				"panel"	=> "basic",
				"name"	=> "promo_percentage",
				"type"	=> "currency",
				"label"	=> "Percentage Discount",
				"required" => false,
				"message" => "Please enter a percentage this discount will apply",
				"requires"=>array(
					"name"=>"is_percentage_based",
					"value"=>"1",
					"default_show"=> false
				),
				"value" => $this->coupon->promo_percentage
			),
			array(
				"panel"	=> "basic",
				"name"	=> "is_shipping_based",
				"type"	=> "checkbox",
				"label"	=> "Shipping Based Coupon?",
				"required" => false,
				"message" => "",
				"onclick" => "ec_admin_coupon_type_change",
				"selected" => false,
				"show"  => array(
					"name" =>"promo_shipping",
					"value"=>"1"
				),
				"value" => $this->coupon->is_shipping_based
			),
			array(
				"panel"	=> "basic",
				"name"	=> "promo_shipping",
				"type"	=> "currency",
				"label"	=> "Shipping Discount",
				"required" => false,
				"message" => "Please enter a dollar amount this discount will apply toward shipping",
				"requires"=>array(
					"name"=>"is_shipping_based",
					"value"=>"1",
					"default_show"=> false
				),
				"value" => $this->coupon->promo_shipping
			),
			array(
				"panel"	=> "basic",
				"name"	=> "is_free_item_based",
				"type"	=> "checkbox",
				"label"	=> "Free Item Based Coupon?",
				"required" => false,
				"message" => "",
				"onclick" => "ec_admin_coupon_type_change",
				"selected" => false,
				//"show"  => array(
					//"name" =>"promo_free_item",
					//"value"=>"1"
				//),
				"value" => $this->coupon->is_free_item_based
			),
			/*array(
				"panel"	=> "basic",
				"name"	=> "promo_free_item",
				"type"	=> "currency",
				"label"	=> "Free Item Discount",
				"required" => false,
				"message" => "Please enter an amount",
				"requires"=>array(
					"name"=>"is_free_item_based",
					"value"=>"1",
					"default_show"=> false
				),
				"value" => $this->coupon->promo_free_item
			),
			array(
				"panel"	=> "basic",
				"name"	=> "is_for_me_based",
				"type"	=> "checkbox",
				"label"	=> "For Me Based Coupon?",
				"required" => false,
				"message" => "",
				"onclick" => "ec_admin_coupon_type_change",
				"selected" => false,
				"show"  => array(
					"name" =>"promo_for_me",
					"value"=>"1"
				),
				"value" => $this->coupon->is_for_me_based
			),
			array(
				"panel"	=> "basic",
				"name"	=> "promo_for_me",
				"type"	=> "currency",
				"label"	=> "For Me Discount",
				"required" => false,
				"message" => "Please enter an amount",
				"requires"=>array(
					"name"=>"is_for_me_based",
					"value"=>"1",
					"default_show"=> false
				),
				"value" => $this->coupon->promo_for_me
			)*/
			
			
		) );
		$this->print_fields( $fields );
	}
	
	
	public function stepthree_fields( ){
		global $wpdb;
		$all_products = $wpdb->get_results( "SELECT ec_product.product_id AS id, ec_product.title AS value FROM ec_product ORDER BY title ASC" );
		$manufacturers = $wpdb->get_results( "SELECT ec_manufacturer.manufacturer_id AS id, ec_manufacturer.name AS value FROM ec_manufacturer ORDER BY name ASC" );
		$categories = $wpdb->get_results( "SELECT ec_category.category_id AS id, ec_category.category_name AS value FROM ec_category ORDER BY category_name ASC" );
		$fields = apply_filters( 'wp_easycart_admin_coupon_details_stepthree_fields_list', array(
		array(
			"panel"	=> "basic",
			"name"	=> "by_all_products",
			"type"	=> "checkbox",
			"label"	=> "Apply to All Products?",
			"onclick" => "ec_admin_coupon_apply_to",
			"required" => false,
			"message" => "",
			"selected" => false,
			"value" => $this->coupon->by_all_products
		),
		array(
			"panel"	=> "basic",
			"name"	=> "by_product_id",
			"type"	=> "checkbox",
			"label"	=> "Apply to only one product?",
			"required" => false,
			"message" => "",
			"onclick" => "ec_admin_coupon_apply_to",
			"selected" => false,
			"show"  => array(
				"name" =>"product_id",
				"value"=>"1"
			),
			"value" => $this->coupon->by_product_id
		),
		array(
			"panel" => "basic",
			"name"	=> "product_id",
			"type"	=> "select",
			"data"	=> $all_products,
			"data_label" => "Select a Product",
			"label" => "Select Product",
			"required" => false,
			"message" => "Please select a product",
			"requires"=>array(
				"name"=>"by_product_id",
				"value"=>"1",
				"default_show"=> false
			),
			"value" => $this->coupon->product_id
			
		),
		array(
			"panel"	=> "basic",
			"name"	=> "by_manufacturer_id",
			"type"	=> "checkbox",
			"label"	=> "Apply to a specific manufacturer?",
			"required" => false,
			"message" => "",
			"onclick" => "ec_admin_coupon_apply_to",
			"selected" => false,
			"show"  => array(
				"name" =>"manufacturer_id",
				"value"=>"1"
			),
			"value" => $this->coupon->by_manufacturer_id
		),
		array(
			"panel" => "basic",
			"name"	=> "manufacturer_id",
			"type"	=> "select",
			"data"	=> $manufacturers,
			"data_label" => "Please Select a Manufacturer",
			"label" => "Select Manufacturer",
			"required" => false,
			"message" => "Please select a manufacturer",
			"requires"=>array(
				"name"=>"by_manufacturer_id",
				"value"=>"1",
				"default_show"=> false
			),
			"value" => $this->coupon->manufacturer_id
		),
		array(
			"panel"	=> "basic",
			"name"	=> "by_category_id",
			"type"	=> "checkbox",
			"label"	=> "Apply to a specific Category?",
			"required" => false,
			"message" => "",
			"onclick" => "ec_admin_coupon_apply_to",
			"selected" => false,
			"show"  => array(
				"name" =>"category_id",
				"value"=>"1"
			),
			"value" => $this->coupon->by_category_id
		),
		array(
			"panel" => "basic",
			"name"	=> "category_id",
			"type"	=> "select",
			"data"	=> $categories,
			"data_label" => "Please select a Category",
			"label" => "Select Category",
			"required" => false,
			"message" => "Please select a category",
			"requires"=>array(
				"name"=>"by_category_id",
				"value"=>"1",
				"default_show"=> false
			),
			"value" => $this->coupon->category_id
		)
			
			
			
		) );
		$this->print_fields( $fields );
	}
	
	public function stepfour_fields( ){
		global $wpdb;
		$styles = array(
			array( 'float', 'none'	)
		);
		$fields = apply_filters( 'wp_easycart_admin_coupon_details_stepthree_fields_list', array(
			array(
				"panel"	=> "basic",
				"name"	=> "minimum_required",
				"type"	=> "number",
				"label"	=> "Minimum Products Required for Coupon to Apply",
				"required" => false,
				"message" => "",
				"selected" => false,
				"value" => $this->coupon->minimum_required,
				"styles" => $styles
			)
		) );
		$this->print_fields( $fields );
	}
	
	
}